/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import buildcraft.api.Orientations;
import buildcraft.api.PowerProvider;
import forestry.core.Proxy;
import forestry.core.config.Config;

public class BioPowerProvider
extends PowerProvider {
    public float lastUsedSecond;
    public float lastReceivedSecond;

    @Override
    public void configure(int latency, int minEnergyReceived, int maxEnergyReceived, int minActivationEnergy, int maxStoredEnergy) {
        super.configure(latency, minEnergyReceived, maxEnergyReceived, minActivationEnergy, maxStoredEnergy);
        this.latency = 0;
    }

    @Override
    public float useEnergy(float min, float max, boolean doUse) {
        float used = super.useEnergy(min, max, doUse);
        if (!Proxy.isMultiplayerWorld() && !Config.disableEnergyStat) {
            this.lastUsedSecond = used;
        }
        return used;
    }

    @Override
    public void receiveEnergy(float quantity, Orientations from) {
        if (!Proxy.isMultiplayerWorld() && !Config.disableEnergyStat) {
            this.lastReceivedSecond = quantity;
        }
        super.receiveEnergy(quantity, from);
    }
}

