/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import buildcraft.api.Orientations;
import forestry.core.ForestryClient;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.utils.EnumTankLevel;
import forge.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderMachine
implements IBlockRenderer {
    private ho model = new ho(){};
    private String gfxBase;
    private boolean resourceLevel = true;
    private boolean productLevel = true;
    private qp basefront = new qp(this.model, 0, 0);
    private qp baseback;
    private qp resourceTank;
    private qp productTank;

    public RenderMachine() {
        this.basefront.a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.basefront.c = 8.0f;
        this.basefront.d = 8.0f;
        this.basefront.e = 8.0f;
        this.baseback = new qp(this.model, 0, 0);
        this.baseback.a(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.baseback.c = 8.0f;
        this.baseback.d = 8.0f;
        this.baseback.e = 8.0f;
        this.resourceTank = new qp(this.model, 0, 0);
        this.resourceTank.a(-6.0f, -8.0f, -6.0f, 12, 16, 6);
        this.resourceTank.c = 8.0f;
        this.resourceTank.d = 8.0f;
        this.resourceTank.e = 8.0f;
        this.productTank = new qp(this.model, 0, 0);
        this.productTank.a(-6.0f, -8.0f, 0.0f, 12, 16, 6);
        this.productTank.c = 8.0f;
        this.productTank.d = 8.0f;
        this.productTank.e = 8.0f;
    }

    public RenderMachine(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    public RenderMachine(String baseTexture, boolean resourceLevel, boolean productLevel) {
        this(baseTexture);
        this.resourceLevel = resourceLevel;
        this.productLevel = productLevel;
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "base.png");
        ForestryClient.preloadTexture(this.gfxBase + "tank_resource_empty.png");
        if (this.resourceLevel) {
            ForestryClient.preloadTexture(this.gfxBase + "tank_resource_low.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_resource_medium.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_resource_high.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_resource_maximum.png");
        }
        ForestryClient.preloadTexture(this.gfxBase + "tank_product_empty.png");
        if (this.productLevel) {
            ForestryClient.preloadTexture(this.gfxBase + "tank_product_low.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_product_medium.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_product_high.png");
            ForestryClient.preloadTexture(this.gfxBase + "tank_product_maximum.png");
        }
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(EnumTankLevel.EMPTY, EnumTankLevel.EMPTY, Orientations.YPos, this.gfxBase, x, y, z);
    }

    @Override
    public void renderTileEntityAt(kw tileentity, double d, double d1, double d2, float f) {
        TileMachine processor = (TileMachine)tileentity;
        if (processor.machine == null) {
            return;
        }
        this.render(processor.machine.getPrimaryLevel(), processor.machine.getSecondaryLevel(), processor.getOrientation(), this.gfxBase, d, d1, d2);
    }

    private void render(EnumTankLevel waterLevel, EnumTankLevel melangeLevel, Orientations orientation, String gfxBase, double x, double y, double z) {
        String texture;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = Orientations.XNeg;
        }
        switch (orientation) {
            case XPos: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case XNeg: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case YPos: {
                translate[1] = 1.0f;
                break;
            }
            case YNeg: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case ZPos: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            case ZNeg: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.basefront.f = angle[0];
        this.basefront.g = angle[1];
        this.basefront.h = angle[2];
        this.baseback.f = angle[0];
        this.baseback.g = angle[1];
        this.baseback.h = angle[2];
        this.resourceTank.f = angle[0];
        this.resourceTank.g = angle[1];
        this.resourceTank.h = angle[2];
        this.productTank.f = angle[0];
        this.productTank.g = angle[1];
        this.productTank.h = angle[2];
        float factor = 0.0625f;
        MinecraftForgeClient.bindTexture((String)(gfxBase + "base.png"));
        this.basefront.a(factor);
        MinecraftForgeClient.bindTexture((String)(gfxBase + "base.png"));
        this.baseback.a(factor);
        switch (waterLevel) {
            case LOW: {
                texture = gfxBase + "tank_resource_low.png";
                break;
            }
            case MEDIUM: {
                texture = gfxBase + "tank_resource_medium.png";
                break;
            }
            case HIGH: {
                texture = gfxBase + "tank_resource_high.png";
                break;
            }
            case MAXIMUM: {
                texture = gfxBase + "tank_resource_maximum.png";
                break;
            }
            default: {
                texture = gfxBase + "tank_resource_empty.png";
            }
        }
        MinecraftForgeClient.bindTexture((String)texture);
        this.resourceTank.a(factor);
        switch (melangeLevel) {
            case LOW: {
                texture = gfxBase + "tank_product_low.png";
                break;
            }
            case MEDIUM: {
                texture = gfxBase + "tank_product_medium.png";
                break;
            }
            case HIGH: {
                texture = gfxBase + "tank_product_high.png";
                break;
            }
            case MAXIMUM: {
                texture = gfxBase + "tank_product_maximum.png";
                break;
            }
            default: {
                texture = gfxBase + "tank_product_empty.png";
            }
        }
        MinecraftForgeClient.bindTexture((String)texture);
        this.productTank.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

