/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.IPowerReceptor;
import buildcraft.api.Orientations;
import buildcraft.api.PowerProvider;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.gadgets.EntityPackage;
import forestry.core.gadgets.Gadget;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketTileUpdate;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.Vect;
import java.util.LinkedList;

public abstract class TileForestry
extends kw
implements io,
INetworkedEntity,
IOwnable,
IErrorSource,
IHintSource {
    protected boolean isInited = false;
    public EntityPackage pack;
    protected int energyConsumed;
    protected int energyLast;
    protected int energyReceived;
    private Orientations orientation = Orientations.XNeg;
    public EnumErrorCode errorState = EnumErrorCode.OK;
    public String owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public Vect Coords() {
        return new Vect(this.j, this.k, this.l);
    }

    public abstract Gadget getMachine();

    public void n_() {
        IPowerReceptor receptor;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (this instanceof IPowerReceptor && (receptor = (IPowerReceptor)((Object)this)).getPowerProvider() != null) {
            PowerProvider powerProvider = receptor.getPowerProvider();
            powerProvider.update(receptor);
        }
    }

    protected abstract void initialize();

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.access = nbttagcompound.c("Access") ? EnumAccess.values()[nbttagcompound.f("Access")] : EnumAccess.SHARED;
        if (nbttagcompound.c("Owner")) {
            this.owner = nbttagcompound.j("Owner");
        }
        this.orientation = nbttagcompound.c("Orientation") ? Orientations.values()[nbttagcompound.f("Orientation")] : Orientations.XNeg;
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Access", this.access.ordinal());
        if (this.owner != null) {
            nbttagcompound.a("Owner", this.owner);
        }
        if (this.orientation != null) {
            nbttagcompound.a("Orientation", this.orientation.ordinal());
        }
    }

    @Override
    public void sendNetworkUpdate() {
        PacketTileUpdate packet = new PacketTileUpdate(this, ForestryAPI.instance);
        NetProxy.sendNetworkPacket(packet, this.j, this.k, this.l);
    }

    public abs getDescriptionPacket() {
        PacketTileUpdate packet = new PacketTileUpdate(this, ForestryAPI.instance);
        return packet.getPacket();
    }

    @Override
    public abstract PacketPayload getPacketPayload();

    public void fromUpdatePacket(PacketTileUpdate packet) {
        this.orientation = packet.getOrientation();
        this.errorState = packet.getErrorState();
        this.owner = packet.getOwner();
        this.access = packet.getAccess();
        this.fromPacketPayload(packet.payload);
    }

    public LinkedList getCustomTriggers() {
        return null;
    }

    public void onRemoval() {
    }

    public boolean isActivated() {
        return this.i.x(this.j, this.k, this.l);
    }

    public Orientations getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientations orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.sendNetworkUpdate();
    }

    public void setErrorState(EnumErrorCode state) {
        if (this.errorState == state) {
            return;
        }
        this.errorState = state;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public EnumErrorCode getErrorState() {
        return this.errorState;
    }

    @Override
    public boolean allowsRemoval(yw player) {
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxy.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED;
    }

    @Override
    public boolean allowsInteraction(yw player) {
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxy.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED || this.getAccess() == EnumAccess.VIEWABLE;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null && !this.owner.isEmpty();
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    public yw getOwnerEntity() {
        if (this.owner != null) {
            return this.i.a(this.owner);
        }
        return null;
    }

    @Override
    public void setOwner(yw player) {
        this.owner = player.aA;
    }

    @Override
    public boolean isOwner(yw player) {
        if (this.owner != null) {
            return this.owner.equals(player.aA);
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(yw player) {
        if (this.owner != null && !this.owner.isEmpty() && !this.owner.equals(player.aA)) {
            return false;
        }
        this.access = this.access.ordinal() < EnumAccess.values().length - 1 ? EnumAccess.values()[this.access.ordinal() + 1] : EnumAccess.values()[0];
        return true;
    }

    public boolean a_(yw player) {
        return this.i.b(this.j, this.k, this.l) != this ? false : player.f((double)this.j + 0.5, (double)this.k + 0.5, (double)this.l + 0.5) <= 64.0;
    }
}

