/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AlleleInteger;
import forestry.core.genetics.AlleleSpecies;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.utils.Vect;

public class Allele
implements IAllele {
    int id;
    boolean isDominant;
    public static AlleleSpecies speciesForest;
    public static AlleleSpecies speciesMeadows;
    public static AlleleSpecies speciesCommon;
    public static AlleleSpecies speciesCultivated;
    public static AlleleSpecies speciesNoble;
    public static AlleleSpecies speciesMajestic;
    public static AlleleSpecies speciesImperial;
    public static AlleleSpecies speciesDiligent;
    public static AlleleSpecies speciesUnweary;
    public static AlleleSpecies speciesIndustrious;
    public static AlleleSpecies speciesSteadfast;
    public static AlleleSpecies speciesValiant;
    public static AlleleSpecies speciesHeroic;
    public static AlleleSpecies speciesSinister;
    public static AlleleSpecies speciesFiendish;
    public static AlleleSpecies speciesDemonic;
    public static AlleleSpecies speciesModest;
    public static AlleleSpecies speciesFrugal;
    public static AlleleSpecies speciesAustere;
    public static AlleleSpecies speciesTropical;
    public static AlleleSpecies speciesExotic;
    public static AlleleSpecies speciesEdenic;
    public static AlleleSpecies speciesEnded;
    public static AlleleSpecies speciesWintry;
    public static AlleleSpecies speciesVindictive;
    public static AlleleSpecies speciesVengeful;
    public static AlleleSpecies speciesAvenging;
    public static AlleleSpecies speciesDarkened;
    public static AlleleSpecies speciesReddened;
    public static AlleleSpecies speciesOmega;
    public static AlleleSpecies speciesLeporine;
    public static AlleleSpecies speciesRural;
    public static AlleleSpecies speciesMarshy;
    public static AlleleSpecies treeOak;
    public static AlleleSpecies treeBirch;
    public static AlleleSpecies treeSpruce;
    public static AlleleSpecies treeTeak;
    public static final Allele boolFalse;
    public static final Allele boolTrue;
    public static final Allele speedSlowest;
    public static final Allele speedSlower;
    public static final Allele speedSlow;
    public static final Allele speedNorm;
    public static final Allele speedFast;
    public static final Allele speedFaster;
    public static final Allele speedFastest;
    public static final Allele lifespanShortest;
    public static final Allele lifespanShorter;
    public static final Allele lifespanShort;
    public static final Allele lifespanShortened;
    public static final Allele lifespanNormal;
    public static final Allele lifespanElongated;
    public static final Allele lifespanLong;
    public static final Allele lifespanLonger;
    public static final Allele lifespanLongest;
    public static final Allele fertilityLow;
    public static final Allele fertilityNormal;
    public static final Allele fertilityHigh;
    public static final Allele fertilityMaximum;
    public static Allele growthLightlevel;
    public static final Allele heightMax1;
    public static final Allele heightMax2;
    public static final Allele heightMax3;
    public static final Allele heightMax4;
    public static final Allele heightMax5;
    public static final Allele heightMax6;
    public static final Allele heightMax7;
    public static final Allele heightMax8;
    public static final Allele heightMax9;
    public static final Allele heightMax10;
    public static final Allele heightMax11;
    public static final Allele heightMax12;
    public static final Allele toleranceNone;
    public static final Allele toleranceBoth1;
    public static final Allele toleranceBoth2;
    public static final Allele toleranceBoth3;
    public static final Allele toleranceBoth4;
    public static final Allele toleranceBoth5;
    public static final Allele toleranceUp1;
    public static final Allele toleranceUp2;
    public static final Allele toleranceUp3;
    public static final Allele toleranceUp4;
    public static final Allele toleranceUp5;
    public static final Allele toleranceDown1;
    public static final Allele toleranceDown2;
    public static final Allele toleranceDown3;
    public static final Allele toleranceDown4;
    public static final Allele toleranceDown5;
    public static Allele flowersVanilla;
    public static Allele flowersNether;
    public static Allele flowersCacti;
    public static Allele flowersMushrooms;
    public static Allele flowersEnd;
    public static Allele flowersJungle;
    public static Allele flowersSnow;
    public static Allele flowersWheat;
    public static final Allele saplingsDefault;
    public static final Allele yieldDefault;
    public static final Allele floweringSlowest;
    public static final Allele floweringSlower;
    public static final Allele floweringSlow;
    public static final Allele floweringMaximum;
    public static final Allele territoryDefault;
    public static final Allele territoryLarge;
    public static final Allele territoryLarger;
    public static final Allele territoryLargest;
    public static Allele effectNone;
    public static Allele effectAggressive;
    public static Allele effectHeroic;
    public static Allele effectBeatific;
    public static Allele effectMiasmic;
    public static Allele effectMisanthrope;
    public static Allele effectGlacial;
    public static Allele effectRadioactive;
    public static Allele effectCreeper;
    public static Allele effectIgnition;
    public static Allele effectExploration;
    public static Allele effectFestiveEaster;
    public static Allele leavesNone;

    public Allele(int id, boolean isDominant) {
        this.id = id;
        this.isDominant = isDominant;
        if (AlleleManager.alleleList[id] != null) {
            throw new RuntimeException("Allele slot " + id + " was already occupied by " + AlleleManager.alleleList[id].toString() + " when trying to add " + this.toString());
        }
        AlleleManager.alleleList[id] = this;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isDominant() {
        return this.isDominant;
    }

    public static void initialize() {
    }

    static {
        boolFalse = new AlleleBoolean(1024, false);
        boolTrue = new AlleleBoolean(1025, true);
        speedSlowest = new AlleleFloat(1100, 0.3f, true);
        speedSlower = new AlleleFloat(1101, 0.6f, true);
        speedSlow = new AlleleFloat(1102, 0.8f, true);
        speedNorm = new AlleleFloat(1103, 1.0f);
        speedFast = new AlleleFloat(1104, 1.2f, true);
        speedFaster = new AlleleFloat(1105, 1.4f);
        speedFastest = new AlleleFloat(1106, 1.7f);
        lifespanShortest = new AlleleInteger(1200, 10, false);
        lifespanShorter = new AlleleInteger(1201, 20, true);
        lifespanShort = new AlleleInteger(1202, 30, true);
        lifespanShortened = new AlleleInteger(1203, 35, true);
        lifespanNormal = new AlleleInteger(1204, 40);
        lifespanElongated = new AlleleInteger(1205, 45, true);
        lifespanLong = new AlleleInteger(1206, 50);
        lifespanLonger = new AlleleInteger(1207, 60);
        lifespanLongest = new AlleleInteger(1208, 70);
        fertilityLow = new AlleleInteger(1300, 1, true);
        fertilityNormal = new AlleleInteger(1301, 2, true);
        fertilityHigh = new AlleleInteger(1302, 3);
        fertilityMaximum = new AlleleInteger(1303, 4);
        heightMax1 = new AlleleInteger(1400, 1);
        heightMax2 = new AlleleInteger(1401, 2);
        heightMax3 = new AlleleInteger(1402, 3);
        heightMax4 = new AlleleInteger(1403, 4);
        heightMax5 = new AlleleInteger(1404, 5);
        heightMax6 = new AlleleInteger(1405, 6);
        heightMax7 = new AlleleInteger(1406, 7);
        heightMax8 = new AlleleInteger(1407, 8);
        heightMax9 = new AlleleInteger(1408, 9);
        heightMax10 = new AlleleInteger(1409, 10);
        heightMax11 = new AlleleInteger(1410, 11);
        heightMax12 = new AlleleInteger(1411, 12);
        toleranceNone = new AlleleTolerance(1450, EnumTolerance.NONE);
        toleranceBoth1 = new AlleleTolerance(1451, EnumTolerance.BOTH_1, true);
        toleranceBoth2 = new AlleleTolerance(1452, EnumTolerance.BOTH_2);
        toleranceBoth3 = new AlleleTolerance(1453, EnumTolerance.BOTH_3);
        toleranceBoth4 = new AlleleTolerance(1454, EnumTolerance.BOTH_4);
        toleranceBoth5 = new AlleleTolerance(1455, EnumTolerance.BOTH_5);
        toleranceUp1 = new AlleleTolerance(1456, EnumTolerance.UP_1, true);
        toleranceUp2 = new AlleleTolerance(1457, EnumTolerance.UP_2);
        toleranceUp3 = new AlleleTolerance(1458, EnumTolerance.UP_3);
        toleranceUp4 = new AlleleTolerance(1459, EnumTolerance.UP_4);
        toleranceUp5 = new AlleleTolerance(1460, EnumTolerance.UP_5);
        toleranceDown1 = new AlleleTolerance(1461, EnumTolerance.DOWN_1, true);
        toleranceDown2 = new AlleleTolerance(1462, EnumTolerance.DOWN_2);
        toleranceDown3 = new AlleleTolerance(1463, EnumTolerance.DOWN_3);
        toleranceDown4 = new AlleleTolerance(1464, EnumTolerance.DOWN_4);
        toleranceDown5 = new AlleleTolerance(1465, EnumTolerance.DOWN_5);
        saplingsDefault = new AlleleFloat(1600, 0.2f, true);
        yieldDefault = new AlleleFloat(1650, 0.2f, true);
        floweringSlowest = new AlleleInteger(1700, 10, true);
        floweringSlower = new AlleleInteger(1701, 20);
        floweringSlow = new AlleleInteger(1702, 30);
        floweringMaximum = new AlleleInteger(1710, 99, true);
        territoryDefault = new AlleleArea(1750, new Vect(9, 3, 9));
        territoryLarge = new AlleleArea(1751, new Vect(11, 5, 11));
        territoryLarger = new AlleleArea(1752, new Vect(13, 7, 13));
        territoryLargest = new AlleleArea(1753, new Vect(15, 9, 15));
    }
}

