/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.Proxy;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.network.PacketTileUpdate;
import forestry.plugins.PluginManager;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate(packetT);
                    break;
                }
                case 72: {
                    PacketSocketUpdate packetS = new PacketSocketUpdate();
                    packetS.readData(data);
                    this.onSocketUpdate(packetS);
                    break;
                }
                case 2: {
                    PacketInventoryStack packetQ = new PacketInventoryStack();
                    packetQ.readData(data);
                    this.onInventoryStack(packetQ);
                    break;
                }
                default: {
                    for (IPacketHandler handler : PluginManager.packetHandlers) {
                        handler.onPacketData(network, channel, bytes);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onSocketUpdate(PacketSocketUpdate packet) {
        kw tile = Proxy.getWorld().b(packet.posX, packet.posY, packet.posZ);
        if (!(tile instanceof ISocketable)) {
            return;
        }
        ISocketable socketable = (ISocketable)tile;
        for (int i = 0; i < packet.itemstacks.length; ++i) {
            socketable.setSocket(i, packet.itemstacks[i]);
        }
    }

    private void onTileUpdate(PacketTileUpdate packet) {
        kw tile = packet.getTarget(Proxy.getWorld());
        if (tile instanceof TileForestry) {
            ((TileForestry)tile).fromUpdatePacket(packet);
        }
    }

    private void onInventoryStack(PacketInventoryStack packet) {
        kw tile = Proxy.getWorld().b(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (!(tile instanceof io)) {
            return;
        }
        ((io)tile).a(packet.slotIndex, packet.itemstack);
    }
}

