/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.interfaces.ISocketable;
import forestry.core.network.PacketCoordinates;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketSocketUpdate
extends PacketCoordinates {
    public aan[] itemstacks;

    public PacketSocketUpdate() {
    }

    public PacketSocketUpdate(int id, int posX, int posY, int posZ, ISocketable tile) {
        super(id, posX, posY, posZ);
        this.itemstacks = new aan[tile.getSocketCount()];
        for (int i = 0; i < tile.getSocketCount(); ++i) {
            this.itemstacks[i] = tile.getSocket(i);
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeShort(this.itemstacks.length);
        for (int i = 0; i < this.itemstacks.length; ++i) {
            this.writeItemStack(this.itemstacks[i], data);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        int sockets = data.readShort();
        this.itemstacks = new aan[sockets];
        for (int i = 0; i < sockets; ++i) {
            this.itemstacks[i] = this.readItemStack(data);
        }
    }
}

