/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.gadgets.TileEngine;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import forestry.energy.ContainerEngineBronze;
import forestry.energy.EngineBronze;
import forestry.energy.GuiEngine;
import forge.ITextureProvider;
import forge.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class GuiEngineBronze
extends GuiEngine {
    public GuiEngineBronze(aak inventory, TileEngine tile) {
        super("/gfx/forestry/gui/bioengine.png", new ContainerEngineBronze(inventory, tile), tile);
        this.slotManager.add(new GuiForestry.LiquidTankSlot(89, 19, tile, 0));
        this.slotManager.add(new GuiForestry.LiquidTankSlot(107, 19, tile, 1));
        this.slotManager.add(new BiogasSlot(30, 47, (EngineBronze)tile.getEngine()));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = StringUtil.localize("tile.engine.0");
        this.u.b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int i, int j) {
        this.drawBackground();
        EngineBronze engine = (EngineBronze)this.tile.getMachine();
        int temp = engine.getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.b(this.guiLeft + 53, this.guiTop + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends GuiForestry.GfxSlot {
        EngineBronze engine;

        public BiogasSlot(int xPos, int yPos, EngineBronze engine) {
            super(xPos, yPos);
            this.engine = engine;
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
            int x;
            if (this.engine == null || this.engine.totalTime <= 0) {
                return;
            }
            yr content = null;
            int liquidImgIndex = 0;
            int squaled = this.engine.burnTime * this.height / this.engine.totalTime;
            if (squaled > this.height) {
                squaled = this.height;
            }
            if (this.engine.currentLiquidId <= 0) {
                return;
            }
            int liquidId = this.engine.currentLiquidId;
            if (liquidId < pb.m.length && pb.m[liquidId] != null) {
                content = pb.m[liquidId];
                liquidImgIndex = pb.m[liquidId].bN;
            } else {
                content = yr.e[liquidId];
                liquidImgIndex = yr.e[liquidId].b(0);
            }
            if (content instanceof ITextureProvider) {
                MinecraftForgeClient.bindTexture((String)((ITextureProvider)content).getTextureFile());
            } else {
                MinecraftForgeClient.bindTexture((String)"/terrain.png");
            }
            int imgLine = liquidImgIndex / 16;
            int imgColumn = liquidImgIndex - imgLine * 16;
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                x = 0;
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                GuiEngineBronze.this.b(startX + this.xPos, startY + this.yPos + this.height - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
            int tex = ((GuiEngineBronze)GuiEngineBronze.this).p.p.b(GuiEngineBronze.this.textureFile);
            ((GuiEngineBronze)GuiEngineBronze.this).p.p.b(tex);
        }

        @Override
        public String getTooltip() {
            if (this.engine.currentLiquidId <= 0) {
                return StringUtil.localize("gui.empty");
            }
            String tooltip = yr.e[this.engine.currentLiquidId].d(null);
            return tooltip;
        }
    }
}

