/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.IStillManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MachineStill
extends Machine {
    public static final short SLOT_OUTPUT = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT = 2;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private aan[] inventoryStacks = new aan[3];
    private Recipe currentRecipe;
    private LiquidStack bufferedLiquid;
    public int distillationTime = 0;
    public int distillationTotalTime = 0;

    public MachineStill(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("still"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.1");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("DistillationTime", this.distillationTime);
        nbttagcompound.a("DistillationTotalTime", this.distillationTotalTime);
        ady NBTresourceSlot = new ady();
        ady NBTproductSlot = new ady();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ResourceTank", (gh)NBTresourceSlot);
        nbttagcompound.a("ProductTank", (gh)NBTproductSlot);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.distillationTime = nbttagcompound.f("DistillationTime");
        this.distillationTotalTime = nbttagcompound.f("DistillationTotalTime");
        this.resourceTank = new TankSlot(10000);
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.m("ProductTank"));
        }
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.a()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.inventoryStacks[2] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[2])) != null && RecipeManager.isInput(container.liquid)) {
            this.inventoryStacks[2] = this.replenishByContainer(this.inventoryStacks[2], container, this.resourceTank);
            if (this.inventoryStacks[2].a <= 0) {
                this.inventoryStacks[2] = null;
            }
        }
        if (this.inventoryStacks[1] != null && (container = LiquidManager.getEmptyContainer(this.inventoryStacks[1], new LiquidStack(this.productTank.liquidId, this.productTank.quantity))) != null) {
            this.inventoryStacks[0] = this.bottleIntoContainer(this.inventoryStacks[1], this.inventoryStacks[0], container, this.productTank);
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        if (this.tile.i.w() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.distillationTime > 0 && this.currentRecipe != null) {
            this.distillationTime -= this.currentRecipe.input.liquidAmount;
            this.addProduct(this.currentRecipe.output.itemID, this.currentRecipe.output.liquidAmount);
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        if (this.currentRecipe != null && this.productTank.quantity + this.currentRecipe.output.liquidAmount <= 10000) {
            int resReq = this.currentRecipe.timePerUnit * this.currentRecipe.input.liquidAmount;
            if (this.resourceTank.quantity >= resReq) {
                this.distillationTime = this.distillationTotalTime = resReq;
                this.resourceTank.empty(resReq, true);
                this.bufferedLiquid = new LiquidStack(this.currentRecipe.input.itemID, resReq, this.currentRecipe.input.itemMeta);
                this.setErrorState(EnumErrorCode.OK);
                return true;
            }
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void addProduct(int id, int amount) {
        this.productTank.fill(null, amount, id, true);
        if (this.productTank.quantity > 10000) {
            this.productTank.quantity = 10000;
        }
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity));
        if (sameRec == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.bufferedLiquid.itemID, this.distillationTime, this.bufferedLiquid.itemMeta));
        }
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
    }

    @Override
    public boolean isWorking() {
        return this.distillationTime > 0;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.quantity >= this.currentRecipe.timePerUnit * this.currentRecipe.input.liquidAmount) && this.productTank.quantity <= this.productTank.capacity - this.currentRecipe.output.liquidAmount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return this.rateTankLevel(this.getProductScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
                break;
            }
            case 4: {
                this.productTank.liquidId = j;
                break;
            }
            case 5: {
                this.productTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.distillationTime);
        iCrafting.a(container, 1, this.distillationTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
        iCrafting.a(container, 4, this.productTank.liquidId);
        iCrafting.a(container, 5, this.productTank.quantity);
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        int inventory;
        LiquidContainer container = LiquidManager.getLiquidContainer(stack);
        if (container != null && RecipeManager.isInput(container.liquid)) {
            inventory = 2;
        } else if (LiquidManager.isEmptyContainer(stack)) {
            inventory = 1;
        } else {
            return false;
        }
        if (this.inventoryStacks[inventory] == null) {
            if (doAdd) {
                this.inventoryStacks[inventory] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        if (!this.inventoryStacks[inventory].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[inventory].c() - this.inventoryStacks[inventory].a;
        if (space <= 0) {
            return false;
        }
        if (doAdd) {
            this.inventoryStacks[inventory].a += stack.a;
            stack.a -= space;
            if (stack.a < 0) {
                stack.a = 0;
            }
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        if (this.inventoryStacks[0] != null) {
            product = new aan(this.inventoryStacks[0].c, 1, this.inventoryStacks[0].i());
            if (doRemove) {
                --this.inventoryStacks[0].a;
                if (this.inventoryStacks[0].a <= 0) {
                    this.inventoryStacks[0] = null;
                }
            }
        }
        return product;
    }

    @Override
    public int a() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        aan removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.tile.d()) {
            itemstack.a = this.tile.d();
        }
    }

    @Override
    public aan b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != id) {
            return 0;
        }
        if (!RecipeManager.isInput(new LiquidStack(id, 1))) {
            return 0;
        }
        int used = this.resourceTank.fill(from, quantity, id, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        int product = 0;
        if (this.productTank.quantity >= quantityMax) {
            product = quantityMax;
            if (doEmpty) {
                this.productTank.quantity -= quantityMax;
            }
        } else {
            product = this.productTank.quantity;
            if (doEmpty) {
                this.productTank.quantity = 0;
            }
        }
        if (doEmpty && product > 0) {
            this.tile.sendNetworkUpdate();
        }
        return product;
    }

    @Override
    public int getLiquidQuantity() {
        return this.productTank.quantity;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank, this.productTank};
    }

    @Override
    public int getLiquidId() {
        return this.productTank.liquidId;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.stillManager.addRecipe(100, new LiquidStack(ForestryItem.liquidBiomass, 10), new LiquidStack(ForestryItem.liquidBiofuel, 3));
    }

    public static class RecipeManager
    implements IStillManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerUnit, LiquidStack input, LiquidStack output) {
            recipes.add(new Recipe(timePerUnit, input, output));
        }

        public static Recipe findMatchingRecipe(LiquidStack item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(LiquidStack res) {
            return RecipeManager.findMatchingRecipe(res) != null;
        }

        @Override
        public List getRecipes() {
            HashMap<aan[], aan[]> recipeList = new HashMap<aan[], aan[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new aan[]{recipe.input.asItemStack()}, new aan[]{recipe.output.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerUnit;
        public final LiquidStack input;
        public final LiquidStack output;

        public Recipe(int timePerUnit, LiquidStack input, LiquidStack output) {
            this.timePerUnit = timePerUnit;
            this.input = input;
            this.output = output;
        }

        public boolean matches(LiquidStack res) {
            if (res == null && this.input == null) {
                return true;
            }
            if (res == null && this.input != null) {
                return false;
            }
            if (res != null && this.input == null) {
                return false;
            }
            return this.input.isLiquidEqual(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineStill((TileMachine)tile);
        }
    }
}

