/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.Proxy;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.SlotClosed;
import forestry.core.gui.SlotCustom;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.mail.EnumAddressee;
import forestry.mail.ILetter;
import forestry.mail.ItemLetter;
import forestry.mail.ItemStamps;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.TradeStationInfo;
import forestry.mail.network.PacketTradeInfo;

public class ContainerLetter
extends ContainerItemInventory {
    private ItemLetter.LetterInventory letterInventory;
    private EnumAddressee recipientType = EnumAddressee.PLAYER;
    private TradeStationInfo tradeInfo = null;

    public ContainerLetter(aak player, ItemLetter.LetterInventory inventory) {
        super(inventory);
        int j;
        int i;
        this.letterInventory = inventory;
        if (!Proxy.isMultiplayerWorld() && this.letterInventory.getLetter().isProcessed() && inventory.parent != null && ItemLetter.getState(inventory.parent.i()) < 2) {
            inventory.parent.b(ItemLetter.encodeMeta(2, ItemLetter.getSize(inventory.parent.i())));
        }
        Object[] validStamps = new Object[]{ItemStamps.class};
        if (this.letterInventory.getLetter().isProcessed()) {
            validStamps = new Object[]{};
        }
        for (i = 0; i < 4; ++i) {
            this.a(new SlotCustom((io)inventory, validStamps, Letter.SLOT_POSTAGE_1 + i, 150, 14 + i * 19).setStackLimit(1));
        }
        if (!this.letterInventory.getLetter().isProcessed()) {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.a(new SlotCustom((io)inventory, new Object[]{ItemLetter.class}, Letter.SLOT_ATTACHMENT_1 + j + i * 9, 17 + j * 18, 98 + i * 18, true));
                }
            }
        } else {
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.a(new SlotClosed(inventory, Letter.SLOT_ATTACHMENT_1 + j + i * 9, 17 + j * 18, 98 + i * 18));
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.a(new yu((io)player, j + i * 9 + 9, 17 + j * 18, 145 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.a(new yu((io)player, i, 17 + i * 18, 203));
        }
        if (this.letterInventory.getLetter() != null && this.letterInventory.getLetter().getRecipients() != null && this.letterInventory.getLetter().getRecipients().length > 0) {
            this.recipientType = this.letterInventory.getLetter().getRecipients()[0].getType();
        }
    }

    @Override
    public void a(yw entityplayer) {
        ILetter letter;
        if (!Proxy.isMultiplayerWorld() && !(letter = this.letterInventory.getLetter()).isProcessed()) {
            letter.setSender(new MailAddress(entityplayer.aA));
        }
        super.a(entityplayer);
    }

    @Override
    protected boolean isAcceptedItem(aan stack) {
        return true;
    }

    public ILetter getLetter() {
        return this.letterInventory.getLetter();
    }

    public void setRecipientType(EnumAddressee type) {
        this.recipientType = type;
    }

    public EnumAddressee getRecipientType() {
        return this.recipientType;
    }

    public void advanceRecipientType() {
        if (this.getRecipientType().ordinal() < EnumAddressee.values().length - 1) {
            this.setRecipientType(EnumAddressee.values()[this.getRecipientType().ordinal() + 1]);
        } else {
            this.setRecipientType(EnumAddressee.values()[0]);
        }
    }

    public void setRecipient(MailAddress address) {
        this.getLetter().setRecipient(address);
        if (!Proxy.isMultiplayerWorld()) {
            return;
        }
        PacketPayload payload = new PacketPayload(1, 0, 1);
        payload.intPayload[0] = this.recipientType.ordinal();
        payload.stringPayload[0] = this.getRecipient().getIdentifier();
        PacketUpdate packet = new PacketUpdate(80, payload);
        NetProxy.sendToServer(packet);
    }

    public void handleSetRecipient(yw player, PacketUpdate packet) {
        MailAddress recipient = new MailAddress(packet.payload.stringPayload[0], EnumAddressee.values()[packet.payload.intPayload[0]]);
        this.getLetter().setRecipient(recipient);
        if (recipient.getType() == EnumAddressee.TRADER) {
            this.updateTradeInfo(player.k, recipient);
            NetProxy.sendToPlayer(new PacketTradeInfo(83, this.tradeInfo), player);
        }
    }

    public MailAddress getRecipient() {
        if (this.getLetter().getRecipients().length > 0) {
            return this.getLetter().getRecipients()[0];
        }
        return null;
    }

    public String getText() {
        return this.getLetter().getText();
    }

    public void setText(String text) {
        this.getLetter().setText(text);
        if (!Proxy.isMultiplayerWorld()) {
            return;
        }
        PacketPayload payload = new PacketPayload(0, 0, 1);
        payload.stringPayload[0] = text;
        PacketUpdate packet = new PacketUpdate(81, payload);
        NetProxy.sendToServer(packet);
    }

    public void handleSetText(PacketUpdate packet) {
        this.getLetter().setText(packet.payload.stringPayload[0]);
    }

    public void updateTradeInfo(xd world, MailAddress address) {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (address.getType() != EnumAddressee.TRADER) {
            return;
        }
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        TradeStation station = PostOffice.getTradeStation(world, address.getIdentifier());
        if (station == null) {
            return;
        }
        this.setTradeInfo(station.getTradeInfo());
    }

    public void handleTradeInfoUpdate(PacketTradeInfo packet) {
        this.setTradeInfo(packet.tradeInfo);
    }

    public TradeStationInfo getTradeInfo() {
        return this.tradeInfo;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.tradeInfo = info;
    }
}

