/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryBlock;
import forestry.api.core.IAchievementHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.AchievementsBee;
import forestry.apiculture.BlockBeehives;
import forestry.apiculture.BlockCandle;
import forestry.apiculture.BlockStump;
import forestry.apiculture.FlowerProviderCacti;
import forestry.apiculture.FlowerProviderEnd;
import forestry.apiculture.FlowerProviderJungle;
import forestry.apiculture.FlowerProviderMushroom;
import forestry.apiculture.FlowerProviderNetherwart;
import forestry.apiculture.FlowerProviderVanilla;
import forestry.apiculture.FlowerProviderWheat;
import forestry.apiculture.GuiHandlerApiculture;
import forestry.apiculture.ItemArmorApiarist;
import forestry.apiculture.ItemBeeGE;
import forestry.apiculture.ItemBeealyzer;
import forestry.apiculture.ItemDrone;
import forestry.apiculture.ItemHabitatLocator;
import forestry.apiculture.ItemHoneycomb;
import forestry.apiculture.ItemImprinter;
import forestry.apiculture.ItemPrincess;
import forestry.apiculture.ItemQueen;
import forestry.apiculture.ItemScoop;
import forestry.apiculture.PackagesApiculture;
import forestry.apiculture.PacketHandlerApiculture;
import forestry.apiculture.WorldGenHiveEnd;
import forestry.apiculture.WorldGenHiveForest;
import forestry.apiculture.WorldGenHiveJungle;
import forestry.apiculture.WorldGenHiveMeadows;
import forestry.apiculture.WorldGenHiveParched;
import forestry.apiculture.WorldGenHiveSnow;
import forestry.apiculture.WorldGenHiveSwamp;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.AlleleEffectAggressive;
import forestry.apiculture.genetics.AlleleEffectBeatific;
import forestry.apiculture.genetics.AlleleEffectCreeper;
import forestry.apiculture.genetics.AlleleEffectExploration;
import forestry.apiculture.genetics.AlleleEffectGlacial;
import forestry.apiculture.genetics.AlleleEffectHeroic;
import forestry.apiculture.genetics.AlleleEffectIgnition;
import forestry.apiculture.genetics.AlleleEffectMiasmic;
import forestry.apiculture.genetics.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.AlleleEffectNone;
import forestry.apiculture.genetics.AlleleEffectRadioactive;
import forestry.apiculture.genetics.AlleleFlowers;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.BreedingManager;
import forestry.apiculture.genetics.EnumBeeType;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceNone;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.core.genetics.Allele;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemOverlay;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;
import forge.IPacketHandler;
import forge.MinecraftForge;
import forge.oredict.OreDictionary;
import java.util.ArrayList;
import java.util.Random;

public class PluginForestryApiculture
extends NativePlugin {
    private ArrayList forestDrops;
    private ArrayList meadowsDrops;
    private ArrayList desertDrops;
    private ArrayList jungleDrops;
    private ArrayList endDrops;
    private ArrayList snowDrops;
    private ArrayList swampDrops;

    @Override
    public boolean isAvailable() {
        return !Config.disableApiculture;
    }

    @Override
    public String getDescription() {
        return "Native Apiculture";
    }

    @Override
    public void preInit() {
        super.preInit();
        this.createHiveDropArrays();
        ForestryBlock.beehives = new BlockBeehives(Config.getOrCreateBlockIdProperty("beehives", 199)).a("oreCopper");
        yr.e[ForestryBlock.beehives.bO] = null;
        yr.e[ForestryBlock.beehives.bO] = new ItemForestryBlock(ForestryBlock.beehives.bO - 256, "oreCopper");
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)1, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)2, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)3, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)4, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)5, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)6, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((pb)ForestryBlock.beehives, (int)7, (String)"scoop", (int)0);
        BeeManager.beeInterface = new BeeHelper();
        ForestryBlock.stump = new BlockStump(Config.getOrCreateBlockIdProperty("stump", 1379), 40).a("stump");
        yr.e[ForestryBlock.stump.bO] = null;
        yr.e[ForestryBlock.stump.bO] = new ItemForestryBlock(ForestryBlock.stump.bO - 256, "stump");
        ForestryBlock.candle = new BlockCandle(Config.getOrCreateBlockIdProperty("candle", 1378), 39).a("candle");
        yr.e[ForestryBlock.candle.bO] = null;
        yr.e[ForestryBlock.candle.bO] = new ItemForestryBlock(ForestryBlock.candle.bO - 256, "candle");
    }

    @Override
    public void doInit() {
        super.doInit();
        this.createAlleles();
        this.registerBeehiveDrops();
        BeeManager.breedingManager = new BreedingManager();
        this.registerTemplates();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerDungeonLoot();
        for (int i = 0; i < 256; ++i) {
            if (AlleleManager.alleleList[i] == null || !((IAlleleBeeSpecies)AlleleManager.alleleList[i]).isCounted()) continue;
            ++BeeManager.beeSpeciesCount;
        }
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerApiculture();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerApiculture();
    }

    @Override
    public IAchievementHandler getAchievementHandler() {
        return new AchievementsBee();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMachinePackage(7, PackagesApiculture.getApiaryPackage());
        GadgetManager.registerMillPackage(3, PackagesApiculture.getApiaristChestPackage());
        GadgetManager.registerMillPackage(4, PackagesApiculture.getAnalyzerPackage());
    }

    @Override
    protected void registerItems() {
        ForestryItem.beeQueen = new ItemQueen(Config.getOrCreateItemIdProperty("beeQueen", 13023)).a("beeQueen");
        ForestryItem.beeDrone = new ItemDrone(Config.getOrCreateItemIdProperty("beeDrone", 13024)).a("beeDrone");
        ForestryItem.beePrincess = new ItemPrincess(Config.getOrCreateItemIdProperty("beePrincess", 13025)).a("beePrincess");
        ForestryItem.beeQueenGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeQueenGE", 13083), EnumBeeType.QUEEN).a("beeQueenGE");
        ForestryItem.beeDroneGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeDroneGE", 13084), EnumBeeType.DRONE).a("beeDroneGE");
        ForestryItem.beePrincessGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beePrincessGE", 13085), EnumBeeType.PRINCESS).a("beePrincessGE");
        ForestryItem.beealyzer = new ItemBeealyzer(Config.getOrCreateItemIdProperty("beealyzer", 13086)).a("beealyzer").e(83);
        ForestryItem.biomeFinder = new ItemHabitatLocator(Config.getOrCreateItemIdProperty("biomeFinder", 13105)).a("biomeFinder").c(9, 6);
        ForestryItem.imprinter = new ItemImprinter(Config.getOrCreateItemIdProperty("imprinter", 13110)).a("imprinter").e(82);
        ForestryItem.scoop = new ItemScoop(Config.getOrCreateItemIdProperty("scoop", 13028)).a("scoop").e(43).f(1);
        MinecraftForge.setToolClass((yr)ForestryItem.scoop, (String)"scoop", (int)3);
        ForestryItem.honeyDrop = new ItemOverlay(Config.getOrCreateItemIdProperty("honeyDrop", 13027), new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("honey", 15512621, 15255572), new ItemOverlay.OverlayInfo("charged", 0x800505, 10225415).setIsSecret(), new ItemOverlay.OverlayInfo("omega", 0x191919, 4885671).setIsSecret()}).setIcons(109, 110).a("honeyDrop");
        OreDictionary.registerOre((String)"dropHoney", (aan)new aan(ForestryItem.honeyDrop, 1, 0));
        ForestryItem.beeswax = new ItemForestry(Config.getOrCreateItemIdProperty("beeswax", 13029)).a("beeswax").e(44);
        OreDictionary.registerOre((String)"itemBeeswax", (aan)new aan(ForestryItem.beeswax));
        ForestryItem.pollen = new ItemOverlay(Config.getOrCreateItemIdProperty("pollen", 13030), new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 10652197, 10652197), new ItemOverlay.OverlayInfo("crystalline", 0xFFFFFF, 12975871)}).setIcons(46, 45).a("pollen");
        OreDictionary.registerOre((String)"itemPollen", (aan)new aan(ForestryItem.pollen));
        ForestryItem.propolis = new ItemOverlay(Config.getOrCreateItemIdProperty("propolis", 13031), new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 12956238), new ItemOverlay.OverlayInfo("sticky", 13012567), new ItemOverlay.OverlayInfo("pulsating", 2936241).setIsSecret(), new ItemOverlay.OverlayInfo("silky", 0xDDFF00)}).setIcons(98, 0).a("propolis");
        ForestryItem.honeydew = new ItemForestry(Config.getOrCreateItemIdProperty("honeydew", 13033)).a("honeydew").e(47);
        OreDictionary.registerOre((String)"dropHoneydew", (aan)new aan(ForestryItem.honeydew));
        ForestryItem.royalJelly = new ItemForestry(Config.getOrCreateItemIdProperty("royalJelly", 13032)).a("royalJelly").e(48);
        OreDictionary.registerOre((String)"dropRoyalJelly", (aan)new aan(ForestryItem.royalJelly));
        ForestryItem.refractoryWax = new ItemForestry(Config.getOrCreateItemIdProperty("refractoryWax", 13069)).a("refractoryWax").e(79);
        ForestryItem.beeComb = new ItemHoneycomb(Config.getOrCreateItemIdProperty("beeCombs", 13104)).a("beeCombs");
        ForestryItem.apiaristHat = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristHelmet", 13100), 0).a("apiaristHelmet").e(101);
        ForestryItem.apiaristChest = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristChest", 13101), 1).a("apiaristChest").e(102);
        ForestryItem.apiaristLegs = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristLegs", 13102), 2).a("apiaristLegs").e(103);
        ForestryItem.apiaristBoots = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristBoots", 13103), 3).a("apiaristBoots").e(104);
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedBeeswax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBeeswax", 13528), new aan(ForestryItem.beeswax)).a("cratedBeeswax").e(30);
        ForestryItem.cratedPollen = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPollen", 13529), new aan(ForestryItem.pollen)).a("cratedPollen").e(31);
        ForestryItem.cratedPropolis = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPropolis", 13530), new aan(ForestryItem.propolis)).a("cratedPropolis").e(32);
        ForestryItem.cratedHoneydew = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneydew", 13531), new aan(ForestryItem.honeydew)).a("cratedHoneydew").e(33);
        ForestryItem.cratedRoyalJelly = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRoyalJelly", 13532), new aan(ForestryItem.royalJelly)).a("cratedRoyalJelly").e(34);
        ForestryItem.cratedHoneycombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneycombs", 13527), new aan(ForestryItem.beeComb, 1, 0)).a("cratedHoneycombs").e(29);
        ForestryItem.cratedCocoaComb = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCocoaComb", 13533), new aan(ForestryItem.beeComb, 1, 1)).a("cratedCocoaComb").e(35);
        ForestryItem.cratedSimmeringCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSimmeringCombs", 13545), new aan(ForestryItem.beeComb, 1, 2)).a("cratedSimmeringCombs").e(47);
        ForestryItem.cratedStringyCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedStringyCombs", 13546), new aan(ForestryItem.beeComb, 1, 3)).a("cratedStringyCombs").e(48);
        ForestryItem.cratedFrozenCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedFrozenCombs", 13547), new aan(ForestryItem.beeComb, 1, 4)).a("cratedFrozenCombs").e(49);
        ForestryItem.cratedDrippingCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedDrippingCombs", 13548), new aan(ForestryItem.beeComb, 1, 5)).a("cratedDrippingCombs").e(50);
        ForestryItem.cratedRefractoryWax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRefractoryWax", 13549), new aan(ForestryItem.refractoryWax)).a("cratedRefractoryWax").e(51);
    }

    @Override
    protected void registerRecipes() {
        Proxy.addRecipe(new aan(ForestryItem.apiaristHat), new Object[]{"###", "# #", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 3)});
        Proxy.addRecipe(new aan(ForestryItem.apiaristChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 3)});
        Proxy.addRecipe(new aan(ForestryItem.apiaristLegs), new Object[]{"###", "# #", "# #", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 3)});
        Proxy.addRecipe(new aan(ForestryItem.apiaristBoots), new Object[]{"# #", "# #", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 3)});
        Proxy.addRecipe(new aan(ForestryItem.biomeFinder), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), yr.aC, Character.valueOf('X'), "ingotBronze"});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), yr.aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), yr.aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxy.addRecipe(new aan(ForestryItem.scoop, 1), new Object[]{"#X#", "###", " # ", Character.valueOf('#'), yr.D, Character.valueOf('X'), pb.ab});
        Proxy.addRecipe(new aan(yr.aM), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ForestryItem.propolis, Character.valueOf('X'), ForestryItem.pollen});
        Proxy.addRecipe(new aan(yr.bB), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.honeydew, Character.valueOf('Y'), yr.bf});
        Proxy.addRecipe(new aan(ForestryItem.honeyedSlice, 4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), yr.U});
        Proxy.addRecipe(new aan(ForestryItem.honeyPot, 1), new Object[]{"# #", " X ", "# #", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxy.addRecipe(new aan(ForestryItem.ambrosia), new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), ForestryItem.honeydew, Character.valueOf('X'), ForestryItem.royalJelly, Character.valueOf('Y'), ForestryItem.waxCapsule});
        Proxy.addRecipe(new aan(ForestryItem.waxCapsule, 2), new Object[]{"###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxy.addRecipe(new aan(ForestryItem.refractoryEmpty, 2), new Object[]{"###", Character.valueOf('#'), ForestryItem.refractoryWax});
        Proxy.addRecipe(new aan(ForestryItem.bituminousPeat), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), ForestryItem.ash, Character.valueOf('X'), ForestryItem.peat, Character.valueOf('Y'), ForestryItem.propolis});
        Proxy.addRecipe(new aan(pb.aq, 2), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('Y'), yr.D});
        Proxy.addRecipe(new aan(ForestryItem.craftingMaterial, 1, 1), new Object[]{"# #", " # ", "# #", Character.valueOf('#'), new aan(ForestryItem.propolis, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(pb.B, 600), null, new aan(ForestryBlock.candle, 18), new Object[]{" X ", "###", "###", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), yr.K});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(pb.B, 200), null, new aan(ForestryBlock.candle, 6), new Object[]{"#X#", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), new aan(ForestryItem.craftingMaterial, 1, 2)});
    }

    @Override
    public void generateSurface(xd world, Random rand, int chunkX, int chunkZ) {
        if (Config.generateBeehives) {
            int randPosZ;
            int randPosY;
            int randPosX;
            int i;
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveForest().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 62;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveJungle().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 1; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveMeadows().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveParched().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveEnd().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveSnow().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveSwamp().a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
    }

    private void registerBeehiveDrops() {
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestTemplate(), 80));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestRainResistTemplate(), 8));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getMeadowsTemplate(), 80));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getModestTemplate(), 80));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getTropicalTemplate(), 80));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
        this.endDrops.add(new HiveDrop(BeeTemplates.getEnderTemplate(), 90));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getWintryTemplate(), 80));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getMarshyTemplate(), 80));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), 3));
    }

    private void registerDungeonLoot() {
        float rarity = Config.dungeonLootRare ? 0.01f : 0.1f;
        Bee bee = new Bee(BeeTemplates.templateAsGenome(BeeTemplates.getSteadfastTemplate()));
        aan beeItem = new aan(ForestryItem.beeDroneGE, 1, Allele.speciesSteadfast.getId());
        ady nbttagcompound = new ady();
        bee.b(nbttagcompound);
        beeItem.d(nbttagcompound);
        MinecraftForge.addDungeonLoot((aan)beeItem, (float)rarity);
    }

    private void createHiveDropArrays() {
        BeeManager.hiveDrops = new ArrayList[7];
        this.forestDrops = new ArrayList();
        BeeManager.hiveDrops[0] = this.forestDrops;
        this.meadowsDrops = new ArrayList();
        BeeManager.hiveDrops[1] = this.meadowsDrops;
        this.desertDrops = new ArrayList();
        BeeManager.hiveDrops[2] = this.desertDrops;
        this.jungleDrops = new ArrayList();
        BeeManager.hiveDrops[3] = this.jungleDrops;
        this.endDrops = new ArrayList();
        BeeManager.hiveDrops[4] = this.endDrops;
        this.snowDrops = new ArrayList();
        BeeManager.hiveDrops[5] = this.snowDrops;
        this.swampDrops = new ArrayList();
        BeeManager.hiveDrops[6] = this.swampDrops;
    }

    private void createAlleles() {
        Allele.speciesForest = new AlleleBeeSpecies(0, true, "bees.species.forest", "nigrocincta", 1691884, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesMeadows = new AlleleBeeSpecies(1, true, "bees.species.meadows", "florea", 15667998, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesCommon = new AlleleBeeSpecies(2, true, "bees.species.common", "cerana", 0xB2B2B2, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 0), 35).setIsSecret();
        Allele.speciesCultivated = new AlleleBeeSpecies(3, true, "bees.species.cultivated", "mellifera", 5715180, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 0), 40).setIsSecret();
        Allele.speciesNoble = new AlleleBeeSpecies(4, false, "bees.species.noble", "nobilis", 15505945, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 5), 20).setIsSecret();
        Allele.speciesMajestic = new AlleleBeeSpecies(5, true, "bees.species.majestic", "regalis", 0x7F0000, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 5), 30).setIsSecret();
        Allele.speciesImperial = new AlleleBeeSpecies(6, false, "bees.species.imperial", "imperatorius", 10739759, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 5), 20).addProduct(new aan(ForestryItem.royalJelly), 15).setHasEffect().setIsSecret();
        Allele.speciesDiligent = new AlleleBeeSpecies(7, false, "bees.species.diligent", "sedulus", 12720620, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 3), 20).setIsSecret();
        Allele.speciesUnweary = new AlleleBeeSpecies(8, true, "bees.species.unweary", "assiduus", 1698906, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 3), 30).setIsSecret();
        Allele.speciesIndustrious = new AlleleBeeSpecies(9, false, "bees.species.industrious", "industria", 0xFFFFFF, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 3), 20).addProduct(new aan(ForestryItem.pollen), 15).setHasEffect().setIsSecret();
        Allele.speciesSteadfast = new AlleleBeeSpecies(10, false, "bees.species.steadfast", "legio", 5057301, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 1), 20).setIsSecret().setHasEffect();
        Allele.speciesValiant = new AlleleBeeSpecies(11, true, "bees.species.valiant", "centurio", 6450141, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 1), 30).addSpecialty(new aan(yr.aY), 15).setIsSecret();
        Allele.speciesHeroic = new AlleleBeeSpecies(12, false, "bees.species.heroic", "kraphti", 11785700, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 1), 40).setIsSecret().setHasEffect();
        Allele.speciesSinister = new AlleleBeeSpecies(13, false, "bees.species.sinister", "caecus", 11785700, 10101539).addProduct(new aan(ForestryItem.beeComb, 1, 2), 45).setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesFiendish = new AlleleBeeSpecies(14, true, "bees.species.fiendish", "diabolus", 14139109, 10101539).addProduct(new aan(ForestryItem.beeComb, 1, 2), 55).addProduct(new aan(ForestryItem.ash), 15).setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesDemonic = new AlleleBeeSpecies(15, false, "bees.species.demonic", "draco", 16049152, 10101539).addProduct(new aan(ForestryItem.beeComb, 1, 2), 45).addProduct(new aan(yr.aT), 15).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesModest = new AlleleBeeSpecies(16, false, "bees.species.modest", "modicus", 12959366, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 7), 20).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesFrugal = new AlleleBeeSpecies(17, true, "bees.species.frugal", "permodestus", 15260849, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 7), 30).setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesAustere = new AlleleBeeSpecies(18, false, "bees.species.austere", "correpere", 16775874, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 7), 20).addSpecialty(new aan(ForestryItem.beeComb, 1, 10), 50).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesTropical = new AlleleBeeSpecies(19, false, "bees.species.tropical", "mendelia", 3637280, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 6), 20).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesExotic = new AlleleBeeSpecies(20, true, "bees.species.exotic", "darwini", 3164419, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 6), 30).setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEdenic = new AlleleBeeSpecies(21, false, "bees.species.edenic", "humboldti", 3751181, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 6), 20).setHasEffect().setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEnded = new AlleleBeeSpecies(22, false, "bees.species.ender", "notchi", 3211834, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 8), 30).setHasEffect().setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesWintry = new AlleleBeeSpecies(25, false, "bees.species.wintry", "brumalis", 0xEFFFFF, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 4), 30).setTemperature(EnumTemperature.ICY);
        Allele.speciesVindictive = new AlleleBeeSpecies(28, false, "bees.species.vindictive", "ultio", 15400947, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 9), 25).setIsSecret().setIsNotCounted();
        Allele.speciesVengeful = new AlleleBeeSpecies(29, false, "bees.species.vengeful", "punire", 12770816, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setIsNotCounted();
        Allele.speciesAvenging = new AlleleBeeSpecies(30, false, "bees.species.avenging", "hostimentum", 0xDDFF00, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setHasEffect().setIsNotCounted();
        Allele.speciesDarkened = new AlleleBeeSpecies(32, false, "bees.species.darkened", "pahimas", 14139109, 2494249).addProduct(new aan(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new aan(ForestryItem.beeComb, 1, 12), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesReddened = new AlleleBeeSpecies(31, false, "bees.species.reddened", "xenophos", 16302529, 2494249).addProduct(new aan(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new aan(ForestryItem.beeComb, 1, 11), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesOmega = new AlleleBeeSpecies(33, false, "bees.species.omega", "slopokis", 0xFEFF8F, 2494249).addProduct(new aan(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new aan(ForestryItem.beeComb, 1, 13), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesLeporine = new AlleleBeeSpecies(34, false, "bees.species.leporine", "lepus", 0xFEFF8F, 3987287).addProduct(new aan(ForestryItem.beeComb, 1, 6), 30).addProduct(new aan(yr.aP), 10).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesRural = new AlleleBeeSpecies(40, false, "bees.species.rural", "rustico", 0xFEFF8F, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 14), 20).setIsSecret();
        Allele.speciesMarshy = new AlleleBeeSpecies(43, true, "bees.species.marshy", "adorasti", 5531174, 0xFFFFFF).addProduct(new aan(ForestryItem.beeComb, 1, 15), 30);
        Allele.flowersVanilla = new AlleleFlowers(1500, new FlowerProviderVanilla(), true);
        Allele.flowersNether = new AlleleFlowers(1501, new FlowerProviderNetherwart());
        Allele.flowersCacti = new AlleleFlowers(1502, new FlowerProviderCacti());
        Allele.flowersMushrooms = new AlleleFlowers(1503, new FlowerProviderMushroom());
        Allele.flowersEnd = new AlleleFlowers(1504, new FlowerProviderEnd());
        Allele.flowersJungle = new AlleleFlowers(1505, new FlowerProviderJungle());
        Allele.flowersSnow = new AlleleFlowers(1506, new FlowerProviderVanilla(), true);
        Allele.flowersWheat = new AlleleFlowers(1507, new FlowerProviderWheat(), true);
        Allele.effectNone = new AlleleEffectNone(1800);
        Allele.effectAggressive = new AlleleEffectAggressive(1801);
        Allele.effectHeroic = new AlleleEffectHeroic(1802);
        Allele.effectBeatific = new AlleleEffectBeatific(1803);
        Allele.effectMiasmic = new AlleleEffectMiasmic(1804);
        Allele.effectMisanthrope = new AlleleEffectMisanthrope(1805);
        Allele.effectGlacial = new AlleleEffectGlacial(1806);
        Allele.effectRadioactive = new AlleleEffectRadioactive(1807);
        Allele.effectCreeper = new AlleleEffectCreeper(1808);
        Allele.effectIgnition = new AlleleEffectIgnition(1809);
        Allele.effectExploration = new AlleleEffectExploration(1810);
        Allele.effectFestiveEaster = new AlleleEffectNone(1811);
    }

    private void registerTemplates() {
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getForestTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMeadowsTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getCommonTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getCultivatedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getNobleTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMajesticTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getImperialTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDiligentTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getUnwearyTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getIndustriousTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getSteadfastTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getValiantTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getHeroicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getSinisterTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getFiendishTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDemonicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getModestTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getFrugalTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getAustereTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getTropicalTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getExoticTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getEdenicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getEnderTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getWintryTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getVindictiveTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getVengefulTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getAvengingTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDarkenedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getReddenedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getOmegaTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getRuralTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getLeporineTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMarshyTemplate());
    }
}

