/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.buildcraft;

import codechicken.nei.GuiManager;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AssemblyRecipeHandler
extends TemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};
    public static LinkedList assemblyRecipes;
    public static Class assemblyRecipeClass;
    public static Field inputField;
    public static Field outputField;
    public static Field energyField;

    public String getRecipeName() {
        return "Assembly Table";
    }

    public boolean hasOverlay(gb gui, dd container, int recipe) {
        return false;
    }

    public String getGuiTexture() {
        return "/gui/crafting.png";
    }

    public void drawExtras(GuiManager gui, int recipe) {
        Integer time = Math.round(((CachedAssemblyRecipe)((Object)this.arecipes.get((int)recipe))).energy);
        String costString = time.toString();
        gui.drawTextCentered(costString, 110, 9, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(84, 23, 24, 18), "buildcraft.assembly", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        try {
            if (outputId.equals("buildcraft.assembly") && ((Object)((Object)this)).getClass() == AssemblyRecipeHandler.class) {
                for (Object irecipe : assemblyRecipes) {
                    if (!assemblyRecipeClass.isInstance(irecipe)) continue;
                    aan[] input = (aan[])inputField.get(irecipe);
                    aan output = (aan)outputField.get(irecipe);
                    float energy = energyField.getFloat(irecipe);
                    this.arecipes.add(new CachedAssemblyRecipe(input, output, energy));
                }
            } else {
                super.loadCraftingRecipes(outputId, results);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void loadCraftingRecipes(aan result) {
        try {
            for (Object irecipe : assemblyRecipes) {
                aan output;
                if (!assemblyRecipeClass.isInstance(irecipe) || !(output = (aan)outputField.get(irecipe)).a(result)) continue;
                aan[] input = (aan[])inputField.get(irecipe);
                float energy = energyField.getFloat(irecipe);
                this.arecipes.add(new CachedAssemblyRecipe(input, output, energy));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void loadUsageRecipes(aan ingredient) {
        try {
            for (Object irecipe : assemblyRecipes) {
                float energy;
                aan output;
                aan[] input;
                CachedAssemblyRecipe recipe;
                if (!assemblyRecipeClass.isInstance(irecipe) || !(recipe = new CachedAssemblyRecipe(input = (aan[])inputField.get(irecipe), output = (aan)outputField.get(irecipe), energy = energyField.getFloat(irecipe))).contains(recipe.ingredients, ingredient)) continue;
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public class CachedAssemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList ingredients;
        PositionedStack result;
        float energy;

        public CachedAssemblyRecipe(aan[] input, aan output, float energy) {
            super((TemplateRecipeHandler)AssemblyRecipeHandler.this);
            this.result = new PositionedStack((Object)output, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(Arrays.asList(input));
            this.energy = energy;
        }

        public void setIngredients(List items) {
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                aan ingredient = (aan)items.get(ingred);
                PositionedStack stack = new PositionedStack((Object)ingredient, 25 + stackorder[ingred][0] * 18, 6 + stackorder[ingred][1] * 18);
                this.ingredients.add(stack);
            }
        }

        public void replaceMetaOnIngredients(aan ingredient) {
            for (PositionedStack stack : this.ingredients) {
                if (stack.item.i() != -1 || !NEIUtils.areStacksSameTypeCrafting((aan)ingredient, (aan)stack.item)) continue;
                stack.item.b(ingredient.i());
            }
        }

        public ArrayList getIngredients() {
            int cycle = AssemblyRecipeHandler.this.cycleticks / 20;
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            for (PositionedStack basestack : this.ingredients) {
                PositionedStack stack = basestack.copy();
                if (stack.item.i() == -1) {
                    int maxDamage = 0;
                    do {
                        stack.item.b(++maxDamage);
                    } while (NEIUtils.isValidItem((aan)stack.item));
                    stack.item.b(cycle % maxDamage);
                }
                cycledstacks.add(stack);
            }
            return cycledstacks;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

