/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.buildcraft;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.liquids.LiquidData;
import buildcraft.api.liquids.LiquidManager;
import buildcraft.api.liquids.LiquidStack;
import codechicken.nei.GuiCraftingRecipe;
import codechicken.nei.GuiManager;
import codechicken.nei.GuiRecipe;
import codechicken.nei.GuiUsageRecipe;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import forge.ITextureProvider;
import forge.MinecraftForgeClient;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class IronEngineFuelsHandler
extends TemplateRecipeHandler {
    static Rectangle fuelTank = new Rectangle(99, 8, 16, 58);
    static Rectangle coolantTank = new Rectangle(117, 8, 16, 58);
    static Point overlayTank = new Point(176, 0);
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.000");

    public String getRecipeName() {
        return "Combustion Engine";
    }

    public void drawLiquidTanks(GuiManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui);
            }
        }
    }

    public PositionedStack[] generateStacksForLiquid(LiquidStack liquid, int x1, int y1, int x2, int y2) {
        ArrayList<aan> empty = new ArrayList<aan>();
        ArrayList<aan> filled = new ArrayList<aan>();
        for (LiquidData cont : LiquidManager.liquids) {
            if (!cont.stillLiquid.isLiquidEqual(liquid)) continue;
            empty.add(cont.container.k());
            filled.add(cont.filled.k());
        }
        if (empty.size() == 0) {
            return new PositionedStack[]{null, new PositionedStack((Object)liquid.asItemStack(), x2, y2)};
        }
        return new PositionedStack[]{new PositionedStack(empty, x1, y1), new PositionedStack(filled, x2, y2)};
    }

    public PositionedStack getSeqCycledStack(int cycle, PositionedStack origstack) {
        PositionedStack stack = origstack.copy();
        if (stack.items.length > 1) {
            stack.setPermutationToRender(cycle % stack.items.length);
        } else if (stack.item.i() == -1) {
            int maxDamage = 0;
            do {
                stack.item.b(++maxDamage);
            } while (NEIUtils.isValidItem((aan)stack.item));
            stack.item.b(cycle % maxDamage);
        }
        return stack;
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = NEIUtils.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.e - offset.x, mousepos.y - guiRecipe.f - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = NEIUtils.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.e - offset.x, mousepos.y - guiRecipe.f - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(147, 11, 12, 12), "buildcraft.ironengine.coolant", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(147, 27, 12, 12), "buildcraft.ironengine.fuel", new Object[0]));
    }

    public void drawForeground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName("gfx/buildcraft/gui/triggers.png");
        if (recipe % 2 == 0) {
            gui.drawTexturedModalRect(150, 30, 5, 21, 6, 6);
            gui.drawTexturedModalRect(150, 14, 37, 21, 6, 6);
        }
        gui.bindTextureByName(this.getGuiTexture());
        this.drawExtras(gui, recipe);
        this.drawLiquidTanks(gui, recipe);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            IronEngineCoolant coolant;
            LiquidStack t = (LiquidStack)ingredients[0];
            IronEngineFuel fuel = IronEngineFuel.getFuelForLiquid((LiquidStack)t);
            if (fuel != null) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
            if ((coolant = IronEngineCoolant.getCoolantForLiquid((LiquidStack)t)) != null) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(aan ingredient) {
        LiquidStack t = this.getLiquidStack(ingredient);
        if (t != null) {
            IronEngineCoolant coolant;
            IronEngineFuel fuel = IronEngineFuel.getFuelForLiquid((LiquidStack)t);
            if (fuel != null) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
            if ((coolant = IronEngineCoolant.getCoolantForLiquid((LiquidStack)t)) != null) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("buildcraft.ironengine.fuel") && ((Object)((Object)this)).getClass() == IronEngineFuelsHandler.class) {
            for (IronEngineCoolant coolant : IronEngineCoolant.coolants) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        } else if (outputId.equals("buildcraft.ironengine.coolant") && ((Object)((Object)this)).getClass() == IronEngineFuelsHandler.class) {
            for (IronEngineFuel fuel : IronEngineFuel.fuels) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public LiquidStack getLiquidStack(aan item) {
        if (item == null) {
            return null;
        }
        for (LiquidData cont : LiquidManager.liquids) {
            if (cont.stillLiquid.isLiquidEqual(item)) {
                return new LiquidStack(item.c, 1000, item.i());
            }
            if (!cont.filled.a(item)) continue;
            return cont.stillLiquid;
        }
        return null;
    }

    public String getGuiTexture() {
        return "gfx/buildcraft/gui/combustion_engine_gui.png";
    }

    public void drawLiquidTank(GuiManager gui, Rectangle position, int liquidId, int quantity, int capacity, Point overlay) {
        int x;
        yr content = null;
        int liquidImgIndex = 0;
        int squaled = quantity * position.height / capacity;
        if (liquidId <= 0) {
            return;
        }
        if (liquidId < pb.m.length && pb.m[liquidId] != null) {
            content = pb.m[liquidId];
            liquidImgIndex = pb.m[liquidId].bN;
        } else {
            content = yr.e[liquidId];
            liquidImgIndex = yr.e[liquidId].b(0);
        }
        if (content instanceof ITextureProvider) {
            MinecraftForgeClient.bindTexture((String)((ITextureProvider)content).getTextureFile());
        } else {
            MinecraftForgeClient.bindTexture((String)"/terrain.png");
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int start = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            gui.drawTexturedModalRect(position.x, position.y + position.height - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        if (overlay != null) {
            gui.bindTextureByName(this.getGuiTexture());
            gui.drawTexturedModalRect(position.x, position.y, overlay.x, overlay.y, position.width, position.height);
        }
    }

    public class IronEngineFuelLiquidTank
    extends LiquidTank {
        public float powerPerCycle;
        public int totalBurningTime;

        public IronEngineFuelLiquidTank(IronEngineFuel fuel, int capacity, Rectangle position, Point overlay) {
            super(new LiquidStack(fuel.liquid.itemID, capacity), capacity, position);
            this.powerPerCycle = fuel.powerPerCycle;
            this.totalBurningTime = fuel.totalBurningTime;
            this.overlay = overlay;
        }

        @Override
        public List handleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add(yr.e[this.liquid.itemID].d(null));
                if (this.showcapacity) {
                    currenttip.add("\u00a77Capacity: " + liquidAmountFormat.format((double)this.capacity * 1.0 / 1000.0));
                }
                currenttip.add("\u00a77Stats per bucket:");
                currenttip.add("\u00a77Output: " + this.powerPerCycle + " MJ/t");
                currenttip.add("\u00a77Duration: " + this.totalBurningTime + " t");
            } else {
                currenttip.add("Empty");
            }
            return currenttip;
        }
    }

    public class IronEngineCoolantLiquidTank
    extends LiquidTank {
        public float coolingPerUnit;

        public IronEngineCoolantLiquidTank(IronEngineCoolant coolant, int capacity, Rectangle position, Point overlay) {
            super(new LiquidStack(coolant.liquid.itemID, capacity), capacity, position);
            this.coolingPerUnit = coolant.coolingPerUnit;
            this.overlay = overlay;
        }

        @Override
        public List handleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add(yr.e[this.liquid.itemID].d(null));
                if (this.showcapacity) {
                    currenttip.add("\u00a77Capacity: " + liquidAmountFormat.format((double)this.capacity * 1.0 / 1000.0));
                }
                currenttip.add("\u00a77Coolant: " + this.coolingPerUnit + "");
            } else {
                currenttip.add("Empty");
            }
            return currenttip;
        }
    }

    public class LiquidTank {
        public LiquidStack liquid;
        public Rectangle position;
        public Point overlay;
        public int capacity;
        public boolean showcapacity;
        public String capacityTitle;

        public LiquidTank(LiquidStack liquid, int capacity, Rectangle position) {
            this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
            this.capacity = capacity;
            this.position = position;
            this.overlay = null;
        }

        public LiquidTank(LiquidStack liquid, int capacity, Rectangle position, Point overlay) {
            this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
            this.capacity = capacity;
            this.position = position;
            this.overlay = overlay;
        }

        public void draw(GuiManager gui) {
            IronEngineFuelsHandler.this.drawLiquidTank(gui, this.position, this.liquid.itemID, this.liquid.amount, this.capacity, this.overlay);
        }

        public List handleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                if (this.showcapacity && this.capacityTitle != null) {
                    currenttip.add(this.capacityTitle);
                } else {
                    currenttip.add(yr.e[this.liquid.itemID].d(null));
                }
                if (this.showcapacity) {
                    currenttip.add("\u00a77Capacity: " + liquidAmountFormat.format((double)this.capacity * 1.0 / 1000.0));
                } else {
                    currenttip.add("\u00a77Amount: " + liquidAmountFormat.format((double)this.liquid.amount * 1.0 / 1000.0));
                }
            } else {
                currenttip.add("Empty");
            }
            return currenttip;
        }
    }

    public class CachedIronEngineRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList slot_input;
        LiquidTank fueltank;
        LiquidTank coolanttank;

        public CachedIronEngineRecipe() {
            super((TemplateRecipeHandler)IronEngineFuelsHandler.this);
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(IronEngineFuelsHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.fueltank);
            res.add(this.coolanttank);
            return res;
        }
    }

    public class CachedIronEngineRecipeCoolant
    extends CachedIronEngineRecipe {
        public CachedIronEngineRecipeCoolant(IronEngineCoolant coolant, LiquidStack liquid) {
            liquid.amount = 10000;
            this.fueltank = new LiquidTank(liquid, 10000, fuelTank, overlayTank);
            this.coolanttank = new IronEngineCoolantLiquidTank(coolant, 10000, coolantTank, overlayTank);
            this.fueltank.showcapacity = true;
            this.coolanttank.showcapacity = true;
            this.fueltank.capacityTitle = "Fuel";
            PositionedStack[] input_cont = IronEngineFuelsHandler.this.generateStacksForLiquid(this.coolanttank.liquid, 47, 14, 47, 30);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
        }
    }

    public class CachedIronEngineRecipeFuel
    extends CachedIronEngineRecipe {
        public CachedIronEngineRecipeFuel(IronEngineFuel fuel, LiquidStack liquid) {
            liquid.amount = 10000;
            this.fueltank = new IronEngineFuelLiquidTank(fuel, 10000, fuelTank, overlayTank);
            this.coolanttank = new LiquidTank(liquid, 10000, coolantTank, overlayTank);
            this.fueltank.showcapacity = true;
            this.coolanttank.showcapacity = true;
            this.coolanttank.capacityTitle = "Coolant";
            PositionedStack[] input_cont = IronEngineFuelsHandler.this.generateStacksForLiquid(this.fueltank.liquid, 47, 14, 47, 30);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
        }
    }

    public static interface ICachedRecipeWithLiquidTank {
        public ArrayList getLiquidTanks();
    }
}

