/*
 * Decompiled with CFR 0.152.
 */
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksItemTreeLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.IllegalFormatException;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;

public class InvTweaksConfigManager {
    private static final Logger log = Logger.getLogger("InvTweaks");
    private Minecraft mc;
    private InvTweaksConfig config = null;
    private long storedConfigLastModified = 0L;
    private InvTweaksHandlerAutoRefill autoRefillHandler = null;
    private InvTweaksHandlerShortcuts shortcutsHandler = null;

    public InvTweaksConfigManager(Minecraft mc) {
        this.mc = mc;
    }

    public boolean makeSureConfigurationIsLoaded() {
        try {
            if (this.config != null && this.config.refreshProperties()) {
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
                InvTweaks.logInGameStatic("invtweaks.propsfile.loaded");
            }
        }
        catch (IOException e) {
            InvTweaks.logInGameErrorStatic("invtweaks.loadconfig.refresh.error", e);
        }
        long configLastModified = this.computeConfigLastModified();
        if (this.config != null) {
            if (this.storedConfigLastModified != configLastModified) {
                return this.loadConfig();
            }
            return true;
        }
        this.storedConfigLastModified = configLastModified;
        return this.loadConfig();
    }

    public InvTweaksConfig getConfig() {
        return this.config;
    }

    public InvTweaksHandlerAutoRefill getAutoRefillHandler() {
        return this.autoRefillHandler;
    }

    public InvTweaksHandlerShortcuts getShortcutsHandler() {
        return this.shortcutsHandler;
    }

    private long computeConfigLastModified() {
        return new File(InvTweaksConst.CONFIG_RULES_FILE).lastModified() + new File(InvTweaksConst.CONFIG_TREE_FILE).lastModified();
    }

    private boolean loadConfig() {
        try {
            if (!InvTweaksItemTreeLoader.isValidVersion(InvTweaksConst.CONFIG_TREE_FILE)) {
                this.backupFile(new File(InvTweaksConst.CONFIG_TREE_FILE), InvTweaksConst.CONFIG_TREE_FILE);
            }
        }
        catch (Exception e) {
            log.warning("Failed to check item tree version: " + e.getMessage());
        }
        if (new File(InvTweaksConst.OLDER_CONFIG_RULES_FILE).exists()) {
            if (new File(InvTweaksConst.CONFIG_RULES_FILE).exists()) {
                this.backupFile(new File(InvTweaksConst.CONFIG_RULES_FILE), InvTweaksConst.CONFIG_RULES_FILE);
            }
            new File(InvTweaksConst.OLDER_CONFIG_RULES_FILE).renameTo(new File(InvTweaksConst.CONFIG_RULES_FILE));
        }
        if (new File(InvTweaksConst.OLDER_CONFIG_TREE_FILE).exists()) {
            this.backupFile(new File(InvTweaksConst.OLDER_CONFIG_TREE_FILE), InvTweaksConst.CONFIG_TREE_FILE);
        }
        if (new File(InvTweaksConst.OLD_CONFIG_TREE_FILE).exists()) {
            new File(InvTweaksConst.OLD_CONFIG_TREE_FILE).renameTo(new File(InvTweaksConst.CONFIG_TREE_FILE));
        }
        if (!new File(InvTweaksConst.CONFIG_RULES_FILE).exists() && this.extractFile("DefaultConfig.dat", InvTweaksConst.CONFIG_RULES_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_RULES_FILE + " " + InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords"));
        }
        if (!new File(InvTweaksConst.CONFIG_TREE_FILE).exists() && this.extractFile("DefaultTree.dat", InvTweaksConst.CONFIG_TREE_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_TREE_FILE + " " + InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords"));
        }
        this.storedConfigLastModified = this.computeConfigLastModified();
        String error = null;
        try {
            if (this.config == null) {
                this.config = new InvTweaksConfig(InvTweaksConst.CONFIG_RULES_FILE, InvTweaksConst.CONFIG_TREE_FILE);
                this.autoRefillHandler = new InvTweaksHandlerAutoRefill(this.mc, this.config);
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
            }
            this.config.load();
            this.shortcutsHandler.reset();
            log.setLevel(this.config.getLogLevel());
            InvTweaks.logInGameStatic("invtweaks.loadconfig.done");
            this.showConfigErrors(this.config);
        }
        catch (FileNotFoundException e) {
            error = "Config file not found";
        }
        catch (Exception e) {
            error = "Error while loading config: " + e.getMessage();
        }
        if (error != null) {
            InvTweaks.logInGameStatic(error);
            log.severe(error);
            this.config = null;
            return false;
        }
        return true;
    }

    private void backupFile(File file, String name) {
        File newFile = new File(name + ".bak");
        if (newFile.exists()) {
            newFile.delete();
        }
        file.renameTo(newFile);
    }

    private boolean extractFile(String resource, String destination) {
        File modFolder;
        File[] zips;
        String resourceContents = "";
        URL resourceUrl = InvTweaks.class.getResource(resource);
        if (resourceUrl != null) {
            try {
                Object o = resourceUrl.getContent();
                if (o instanceof InputStream) {
                    InputStream content = (InputStream)o;
                    while (content.available() > 0) {
                        byte[] bytes = new byte[content.available()];
                        content.read(bytes);
                        resourceContents = resourceContents + new String(bytes);
                    }
                }
            }
            catch (IOException e) {
                resourceUrl = null;
            }
        }
        if (resourceUrl == null && (zips = (modFolder = new File(InvTweaksConst.MINECRAFT_DIR + File.separatorChar + "mods")).listFiles()) != null && zips.length > 0) {
            for (File zip : zips) {
                try {
                    ZipFile invTweaksZip = new ZipFile(zip);
                    ZipEntry zipResource = invTweaksZip.getEntry(resource);
                    if (zipResource == null) continue;
                    InputStream content = invTweaksZip.getInputStream(zipResource);
                    while (content.available() > 0) {
                        byte[] bytes = new byte[content.available()];
                        content.read(bytes);
                        resourceContents = resourceContents + new String(bytes);
                    }
                    break;
                }
                catch (Exception e) {
                    log.warning("Failed to extract " + resource + " from mod: " + e.getMessage());
                }
            }
        }
        if (!resourceContents.isEmpty()) {
            try {
                FileWriter f = new FileWriter(destination);
                f.write(resourceContents);
                f.close();
                return true;
            }
            catch (IOException e) {
                try {
                    InvTweaks.logInGameStatic(String.format(InvTweaksLocalization.get("invtweaks.extract.create.error"), destination));
                }
                catch (IllegalFormatException e2) {
                    InvTweaks.logInGameStatic("[16] The mod won't work, because " + destination + " creation failed!");
                }
                log.severe("Cannot create " + destination + " file: " + e.getMessage());
                return false;
            }
        }
        try {
            InvTweaks.logInGameStatic(String.format(InvTweaksLocalization.get("invtweaks.extract.find.error"), resource));
        }
        catch (IllegalFormatException e2) {
            InvTweaks.logInGameStatic("[15] The mod won't work, because " + resource + " creation failed!");
        }
        log.severe("Cannot create " + destination + " file: " + resource + " not found");
        return false;
    }

    private void showConfigErrors(InvTweaksConfig config) {
        Vector<String> invalid = config.getInvalidKeywords();
        if (invalid.size() > 0) {
            String error = InvTweaksLocalization.get("invtweaks.loadconfig.invalidkeywords") + ": ";
            for (String keyword : config.getInvalidKeywords()) {
                error = error + keyword + " ";
            }
            InvTweaks.logInGameStatic(error);
        }
    }
}

