/*
 * Decompiled with CFR 0.152.
 */
import invtweaks.InvTweaksConst;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import org.lwjgl.util.Point;

public class InvTweaksGuiSettings
extends InvTweaksGuiSettingsAbstract {
    private static final Logger log = Logger.getLogger("InvTweaks");
    private static final int ID_MIDDLE_CLICK = 1;
    private static final int ID_CHESTS_BUTTONS = 2;
    private static final int ID_SHORTCUTS = 3;
    private static final int ID_SHORTCUTS_HELP = 4;
    private static final int ID_AUTO_REFILL = 5;
    private static final int ID_MORE_OPTIONS = 6;
    private static final int ID_EDITRULES = 100;
    private static final int ID_EDITTREE = 101;
    private static final int ID_HELP = 102;
    private static String labelMiddleClick;
    private static String labelChestButtons;
    private static String labelShortcuts;
    private static String labelAutoRefill;
    private static String labelMoreOptions;

    public InvTweaksGuiSettings(Minecraft mc, vp parentScreen, InvTweaksConfig config) {
        super(mc, parentScreen, config);
        labelMiddleClick = InvTweaksLocalization.get("invtweaks.settings.middleclick");
        labelChestButtons = InvTweaksLocalization.get("invtweaks.settings.chestbuttons");
        labelShortcuts = InvTweaksLocalization.get("invtweaks.settings.shortcuts");
        labelAutoRefill = InvTweaksLocalization.get("invtweaks.settings.autorefill");
        labelMoreOptions = InvTweaksLocalization.get("invtweaks.settings.moreoptions");
    }

    @Override
    public void c() {
        super.c();
        List<Object> controlList = this.obf.getControlList(this);
        Point p = new Point();
        int i = 0;
        this.moveToButtonCoords(1, p);
        controlList.add(new abp(100, p.getX() + 55, this.obf.getHeight(this) / 6 + 96, InvTweaksLocalization.get("invtweaks.settings.rulesfile")));
        controlList.add(new abp(101, p.getX() + 55, this.obf.getHeight(this) / 6 + 120, InvTweaksLocalization.get("invtweaks.settings.treefile")));
        controlList.add(new abp(102, p.getX() + 55, this.obf.getHeight(this) / 6 + 144, InvTweaksLocalization.get("invtweaks.settings.onlinehelp")));
        String middleClick = this.config.getProperty("enableMiddleClick");
        this.moveToButtonCoords(i++, p);
        InvTweaksGuiTooltipButton middleClickBtn = new InvTweaksGuiTooltipButton(1, p.getX(), p.getY(), this.computeBooleanButtonLabel("enableMiddleClick", labelMiddleClick), InvTweaksLocalization.get("invtweaks.settings.middleclick.tooltip"));
        controlList.add((Object)middleClickBtn);
        if (middleClick.equals("convenientInventoryCompatibility")) {
            this.obf.setEnabled(middleClickBtn, false);
            middleClickBtn.setTooltip(middleClickBtn.getTooltip() + "\n(" + InvTweaksLocalization.get("invtweaks.settings.disableci.tooltip"));
        }
        this.moveToButtonCoords(i++, p);
        controlList.add((Object)new InvTweaksGuiTooltipButton(4, p.getX() + 130, p.getY(), 20, 20, "?", "Shortcuts help"));
        String shortcuts = this.config.getProperty("enableShortcuts");
        InvTweaksGuiTooltipButton shortcutsBtn = new InvTweaksGuiTooltipButton(3, p.getX(), p.getY(), 130, 20, this.computeBooleanButtonLabel("enableShortcuts", labelShortcuts), InvTweaksLocalization.get("invtweaks.settings.shortcuts.tooltip"));
        controlList.add((Object)shortcutsBtn);
        if (shortcuts.equals("convenientInventoryCompatibility")) {
            this.obf.setEnabled(shortcutsBtn, false);
            shortcutsBtn.setTooltip(shortcutsBtn.getTooltip() + "\n(" + InvTweaksLocalization.get("invtweaks.settings.disableci.tooltip") + ")");
        }
        this.moveToButtonCoords(i++, p);
        InvTweaksGuiTooltipButton autoRefillBtn = new InvTweaksGuiTooltipButton(5, p.getX(), p.getY(), this.computeBooleanButtonLabel("enableAutoRefill", labelAutoRefill), InvTweaksLocalization.get("invtweaks.settings.autorefill.tooltip"));
        controlList.add((Object)autoRefillBtn);
        this.moveToButtonCoords(i++, p);
        controlList.add((Object)new InvTweaksGuiTooltipButton(2, p.getX(), p.getY(), this.computeBooleanButtonLabel("showChestButtons", labelChestButtons), InvTweaksLocalization.get("invtweaks.settings.chestbuttons.tooltip")));
        this.moveToButtonCoords(i++, p);
        this.moveToButtonCoords(i++, p);
        controlList.add((Object)new InvTweaksGuiTooltipButton(6, p.getX(), p.getY(), labelMoreOptions, InvTweaksLocalization.get("invtweaks.settings.moreoptions.tooltip")));
        if (!Desktop.isDesktopSupported()) {
            for (Object o : controlList) {
                abp button;
                if (!this.obf.isGuiButton(o) || this.obf.getId(button = (abp)o) < 100 || this.obf.getId(button) > 102) continue;
                this.obf.setEnabled(button, false);
            }
        }
        this.obf.setControlList(this, controlList);
    }

    @Override
    protected void a(abp guibutton) {
        super.a(guibutton);
        switch (this.obf.getId(guibutton)) {
            case 1: {
                this.toggleBooleanButton(guibutton, "enableMiddleClick", labelMiddleClick);
                break;
            }
            case 2: {
                this.toggleBooleanButton(guibutton, "showChestButtons", labelChestButtons);
                break;
            }
            case 5: {
                this.toggleBooleanButton(guibutton, "enableAutoRefill", labelAutoRefill);
                break;
            }
            case 3: {
                this.toggleBooleanButton(guibutton, "enableShortcuts", labelShortcuts);
                break;
            }
            case 4: {
                this.obf.displayGuiScreen(new InvTweaksGuiShortcutsHelp(this.mc, this, this.config));
                break;
            }
            case 6: {
                this.obf.displayGuiScreen(new InvTweaksGuiSettingsAdvanced(this.mc, this.parentScreen, this.config));
                break;
            }
            case 100: {
                try {
                    Desktop.getDesktop().open(new File(InvTweaksConst.CONFIG_RULES_FILE));
                }
                catch (Exception e) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.rulesfile.error", e);
                }
                break;
            }
            case 101: {
                try {
                    Desktop.getDesktop().open(new File(InvTweaksConst.CONFIG_TREE_FILE));
                }
                catch (Exception e) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.treefile.error", e);
                }
                break;
            }
            case 102: {
                try {
                    Desktop.getDesktop().browse(new URL("http://modding.kalam-alami.net/invtweaks").toURI());
                    break;
                }
                catch (Exception e) {
                    InvTweaks.logInGameErrorStatic("invtweaks.settings.onlinehelp.error", e);
                }
            }
        }
    }
}

