/*
 * Decompiled with CFR 0.152.
 */
import net.minecraft.client.Minecraft;

public class InvTweaksGuiTooltipButton
extends InvTweaksObfuscationGuiButton {
    public static final int DEFAULT_BUTTON_WIDTH = 200;
    public static final int LINE_HEIGHT = 11;
    private int hoverTime = 0;
    private long prevSystemTime = 0L;
    private String tooltip = null;
    private String[] tooltipLines = null;
    private int tooltipWidth = -1;

    public InvTweaksGuiTooltipButton(int id, int x, int y2, String displayString) {
        this(id, x, y2, 150, 20, displayString, null);
    }

    public InvTweaksGuiTooltipButton(int id, int x, int y2, String displayString, String tooltip) {
        this(id, x, y2, 150, 20, displayString, tooltip);
    }

    public InvTweaksGuiTooltipButton(int id, int x, int y2, int w, int h, String displayString) {
        this(id, x, y2, w, h, displayString, null);
    }

    public InvTweaksGuiTooltipButton(int id, int x, int y2, int w, int h, String displayString, String tooltip) {
        super(id, x, y2, w, h, displayString);
        if (tooltip != null) {
            this.setTooltip(tooltip);
        }
    }

    public void a(Minecraft minecraft, int i, int j) {
        super.a(minecraft, i, j);
        InvTweaksObfuscation obf = new InvTweaksObfuscation(minecraft);
        if (!this.isEnabled2()) {
            return;
        }
        if (this.tooltipLines != null) {
            if (this.isMouseOverButton(i, j)) {
                long systemTime = System.currentTimeMillis();
                if (this.prevSystemTime != 0L) {
                    this.hoverTime = (int)((long)this.hoverTime + (systemTime - this.prevSystemTime));
                }
                this.prevSystemTime = systemTime;
            } else {
                this.hoverTime = 0;
                this.prevSystemTime = 0L;
            }
            if (this.hoverTime > 800 && this.tooltipLines != null) {
                nl fontRenderer = obf.getFontRenderer();
                int x = i + 12;
                int y2 = j - 11 * this.tooltipLines.length;
                if (this.tooltipWidth == -1) {
                    for (String line : this.tooltipLines) {
                        this.tooltipWidth = Math.max(obf.getStringWidth(fontRenderer, line), this.tooltipWidth);
                    }
                }
                if (x + this.tooltipWidth > obf.getWidth(obf.getCurrentScreen())) {
                    x = obf.getWidth(obf.getCurrentScreen()) - this.tooltipWidth;
                }
                this.drawGradientRect(x - 3, y2 - 3, x + this.tooltipWidth + 3, y2 + 11 * this.tooltipLines.length, -1073741824, -1073741824);
                int lineCount = 0;
                for (String line : this.tooltipLines) {
                    obf.drawStringWithShadow(fontRenderer, line, x, y2 + lineCount++ * 11, -1);
                }
            }
        }
    }

    protected boolean isMouseOverButton(int i, int j) {
        return i >= this.getXPosition() && j >= this.getYPosition() && i < this.getXPosition() + this.getWidth() && j < this.getYPosition() + this.getHeight();
    }

    protected int getTextColor(int i, int j) {
        int textColor = -2039584;
        if (!this.isEnabled()) {
            textColor = -6250336;
        } else if (this.isMouseOverButton(i, j)) {
            textColor = -96;
        }
        return textColor;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.tooltipLines = tooltip.split("\n");
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

