/*
 * Decompiled with CFR 0.152.
 */
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;

public class InvTweaksHandlerSorting
extends InvTweaksObfuscation {
    private static final Logger log = Logger.getLogger("InvTweaks");
    public static final boolean STACK_NOT_EMPTIED = true;
    public static final boolean STACK_EMPTIED = false;
    private static int[] DEFAULT_LOCK_PRIORITIES = null;
    private static boolean[] DEFAULT_FROZEN_SLOTS = null;
    private static final int MAX_CONTAINER_SIZE = 999;
    public static final int ALGORITHM_DEFAULT = 0;
    public static final int ALGORITHM_VERTICAL = 1;
    public static final int ALGORITHM_HORIZONTAL = 2;
    public static final int ALGORITHM_INVENTORY = 3;
    public static final int ALGORITHM_EVEN_STACKS = 4;
    private InvTweaksContainerSectionManager containerMgr;
    private int algorithm;
    private int size;
    private boolean sortArmorParts;
    private InvTweaksItemTree tree;
    private Vector<InvTweaksConfigSortingRule> rules;
    private int[] rulePriority;
    private int[] keywordOrder;
    private int[] lockPriorities;
    private boolean[] frozenSlots;

    public InvTweaksHandlerSorting(Minecraft mc, InvTweaksConfig config, InvTweaksContainerSection section, int algorithm, int rowSize) throws Exception {
        super(mc);
        int i;
        if (DEFAULT_LOCK_PRIORITIES == null) {
            DEFAULT_LOCK_PRIORITIES = new int[999];
            for (i = 0; i < 999; ++i) {
                InvTweaksHandlerSorting.DEFAULT_LOCK_PRIORITIES[i] = 0;
            }
        }
        if (DEFAULT_FROZEN_SLOTS == null) {
            DEFAULT_FROZEN_SLOTS = new boolean[999];
            for (i = 0; i < 999; ++i) {
                InvTweaksHandlerSorting.DEFAULT_FROZEN_SLOTS[i] = false;
            }
        }
        this.containerMgr = new InvTweaksContainerSectionManager(mc, section);
        this.size = this.containerMgr.getSize();
        this.sortArmorParts = config.getProperty("enableAutoEquipArmor").equals("true");
        this.rules = config.getRules();
        this.tree = config.getTree();
        if (section == InvTweaksContainerSection.INVENTORY) {
            this.lockPriorities = config.getLockPriorities();
            this.frozenSlots = config.getFrozenSlots();
            this.algorithm = 3;
        } else {
            this.lockPriorities = DEFAULT_LOCK_PRIORITIES;
            this.frozenSlots = DEFAULT_FROZEN_SLOTS;
            this.algorithm = algorithm;
            if (algorithm != 0) {
                this.computeLineSortingRules(rowSize, algorithm == 2);
            }
        }
        this.rulePriority = new int[this.size];
        this.keywordOrder = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.rulePriority[i] = -1;
            aan stack = this.containerMgr.getItemStack(i);
            this.keywordOrder[i] = stack != null ? this.getItemOrder(stack) : -1;
        }
    }

    public void sort() throws TimeoutException {
        long timer = System.nanoTime();
        InvTweaksContainerManager globalContainer = new InvTweaksContainerManager(this.mc);
        if (this.algorithm != 0) {
            if (this.algorithm == 3) {
                log.info("Handling crafting slots.");
                if (globalContainer.hasSection(InvTweaksContainerSection.CRAFTING_IN)) {
                    List<yu> craftingSlots = globalContainer.getSlots(InvTweaksContainerSection.CRAFTING_IN);
                    int emptyIndex = globalContainer.getFirstEmptyIndex(InvTweaksContainerSection.INVENTORY);
                    if (emptyIndex != -1) {
                        for (yu craftingSlot : craftingSlots) {
                            if (!this.hasStack(craftingSlot)) continue;
                            globalContainer.move(InvTweaksContainerSection.CRAFTING_IN, globalContainer.getSlotIndex(this.getSlotNumber(craftingSlot)), InvTweaksContainerSection.INVENTORY, emptyIndex);
                            emptyIndex = globalContainer.getFirstEmptyIndex(InvTweaksContainerSection.INVENTORY);
                            if (emptyIndex != -1) continue;
                            break;
                        }
                    }
                }
                log.info("Merging stacks.");
                block1: for (int i = this.size - 1; i >= 0; --i) {
                    aan from = this.containerMgr.getItemStack(i);
                    if (from == null) continue;
                    yr fromItem = this.getItem(from);
                    if (this.isDamageable(fromItem)) {
                        if (!this.sortArmorParts || !this.isItemArmor(fromItem)) continue;
                        ql fromItemArmor = (ql)fromItem;
                        if (!globalContainer.hasSection(InvTweaksContainerSection.ARMOR)) continue;
                        List<yu> armorSlots = globalContainer.getSlots(InvTweaksContainerSection.ARMOR);
                        for (yu slot : armorSlots) {
                            boolean move = false;
                            if (!this.hasStack(slot)) {
                                move = true;
                            } else {
                                int armorLevel = this.getArmorLevel((ql)this.getItem(this.getStack(slot)));
                                if (armorLevel < this.getArmorLevel(fromItemArmor) || armorLevel == this.getArmorLevel(fromItemArmor) && this.getItemDamage(this.getStack(slot)) < this.getItemDamage(from)) {
                                    move = true;
                                }
                            }
                            if (!this.isItemValid(slot, from) || !move) continue;
                            globalContainer.move(InvTweaksContainerSection.INVENTORY, i, InvTweaksContainerSection.ARMOR, globalContainer.getSlotIndex(this.getSlotNumber(slot)));
                        }
                        continue;
                    }
                    int j = 0;
                    int[] arr$ = this.lockPriorities;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        aan to;
                        Integer lockPriority = arr$[i$];
                        if (lockPriority > 0 && (to = this.containerMgr.getItemStack(j)) != null && this.areItemsEqual(from, to)) {
                            this.move(i, j, Integer.MAX_VALUE);
                            this.markAsNotMoved(j);
                            if (this.containerMgr.getItemStack(i) == null) continue block1;
                        }
                        ++j;
                    }
                }
            }
            log.info("Applying rules.");
            for (InvTweaksConfigSortingRule rule : this.rules) {
                int rulePriority = rule.getPriority();
                if (log.getLevel() == InvTweaksConst.DEBUG) {
                    log.info("Rule : " + rule.getKeyword() + "(" + rulePriority + ")");
                }
                block5: for (int i = 0; i < this.size; ++i) {
                    List<InvTweaksItemTreeItem> fromItems;
                    aan from = this.containerMgr.getItemStack(i);
                    if (!this.hasToBeMoved(i) || this.lockPriorities[i] >= rulePriority || !this.tree.matches(fromItems = this.tree.getItems(this.getItemID(from), this.getItemDamage(from)), rule.getKeyword())) continue;
                    int[] preferredSlots = rule.getPreferredSlots();
                    int stackToMove = i;
                    for (int j = 0; j < preferredSlots.length; ++j) {
                        int k = preferredSlots[j];
                        int moveResult = this.move(stackToMove, k, rulePriority);
                        if (moveResult == -1) continue;
                        if (moveResult == k || !this.tree.matches(fromItems = this.tree.getItems(this.getItemID(from = this.containerMgr.getItemStack(moveResult)), this.getItemDamage(from)), rule.getKeyword())) continue block5;
                        stackToMove = moveResult;
                        j = -1;
                    }
                }
            }
            log.info("Locking stacks.");
            for (int i = 0; i < this.size; ++i) {
                if (!this.hasToBeMoved(i) || this.lockPriorities[i] <= 0) continue;
                this.markAsMoved(i, 1);
            }
        }
        this.defaultSorting();
        if (log.getLevel() == InvTweaksConst.DEBUG) {
            timer = System.nanoTime() - timer;
            log.info("Sorting done in " + timer + "ns");
        }
    }

    private void defaultSorting() throws TimeoutException {
        log.info("Default sorting.");
        Vector<Integer> remaining = new Vector<Integer>();
        Vector<Integer> nextRemaining = new Vector<Integer>();
        for (int i = 0; i < this.size; ++i) {
            if (!this.hasToBeMoved(i)) continue;
            remaining.add(i);
            nextRemaining.add(i);
        }
        int iterations = 0;
        while (remaining.size() > 0 && iterations++ < 50) {
            Iterator i$ = remaining.iterator();
            block2: while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (this.hasToBeMoved(i)) {
                    for (int j = 0; j < this.size; ++j) {
                        if (this.move(i, j, 1) == -1) continue;
                        nextRemaining.remove((Object)j);
                        continue block2;
                    }
                    continue;
                }
                nextRemaining.remove((Object)i);
            }
            remaining.clear();
            remaining.addAll(nextRemaining);
        }
        if (iterations == 50) {
            log.warning("Sorting takes too long, aborting.");
        }
    }

    private int move(int i, int j, int priority) throws TimeoutException {
        aan from = this.containerMgr.getItemStack(i);
        aan to = this.containerMgr.getItemStack(j);
        if (from == null || this.frozenSlots[j] || this.frozenSlots[i]) {
            return -1;
        }
        if (this.lockPriorities[i] <= priority) {
            if (i == j) {
                this.markAsMoved(i, priority);
                return j;
            }
            if (to == null && this.lockPriorities[j] <= priority && !this.frozenSlots[j]) {
                this.rulePriority[i] = -1;
                this.keywordOrder[i] = -1;
                this.rulePriority[j] = priority;
                this.keywordOrder[j] = this.getItemOrder(from);
                this.containerMgr.move(i, j);
                return j;
            }
            if (to != null) {
                boolean canBeSwappedOrMerged = false;
                if (this.lockPriorities[j] <= priority) {
                    if (this.rulePriority[j] < priority) {
                        canBeSwappedOrMerged = true;
                    } else if (this.rulePriority[j] == priority && this.isOrderedBefore(i, j)) {
                        canBeSwappedOrMerged = true;
                    }
                }
                if (this.areItemsEqual(from, to)) {
                    if (this.getStackSize(to) < this.getMaxStackSize(to)) {
                        canBeSwappedOrMerged = true;
                    } else if (this.getStackSize(from) > this.getMaxStackSize(from)) {
                        canBeSwappedOrMerged = false;
                    }
                }
                if (canBeSwappedOrMerged) {
                    this.keywordOrder[j] = this.keywordOrder[i];
                    this.rulePriority[j] = priority;
                    this.rulePriority[i] = -1;
                    this.rulePriority[i] = -1;
                    this.containerMgr.move(i, j);
                    aan remains = this.containerMgr.getItemStack(i);
                    if (remains != null) {
                        int dropSlot = i;
                        if (this.lockPriorities[j] > this.lockPriorities[i]) {
                            for (int k = 0; k < this.size; ++k) {
                                if (this.containerMgr.getItemStack(k) != null || this.lockPriorities[k] != 0) continue;
                                dropSlot = k;
                                break;
                            }
                        }
                        if (dropSlot != i) {
                            this.containerMgr.move(i, dropSlot);
                        }
                        this.rulePriority[dropSlot] = -1;
                        this.keywordOrder[dropSlot] = this.getItemOrder(remains);
                        return dropSlot;
                    }
                    return j;
                }
            }
        }
        return -1;
    }

    private void markAsMoved(int i, int priority) {
        this.rulePriority[i] = priority;
    }

    private void markAsNotMoved(int i) {
        this.rulePriority[i] = -1;
    }

    private boolean hasToBeMoved(int slot) {
        return this.containerMgr.getItemStack(slot) != null && this.rulePriority[slot] == -1;
    }

    private boolean isOrderedBefore(int i, int j) {
        aan iStack = this.containerMgr.getItemStack(i);
        aan jStack = this.containerMgr.getItemStack(j);
        if (jStack == null) {
            return true;
        }
        if (iStack == null || this.keywordOrder[i] == -1) {
            return false;
        }
        if (this.keywordOrder[i] == this.keywordOrder[j]) {
            if (this.getItemID(iStack) == this.getItemID(jStack)) {
                if (this.getStackSize(iStack) == this.getStackSize(jStack)) {
                    int damageDiff = this.getItemDamage(iStack) - this.getItemDamage(jStack);
                    return damageDiff < 0 && !this.isItemStackDamageable(iStack) || damageDiff > 0 && this.isItemStackDamageable(iStack);
                }
                return this.getStackSize(iStack) > this.getStackSize(jStack);
            }
            return this.getItemID(iStack) > this.getItemID(jStack);
        }
        return this.keywordOrder[i] < this.keywordOrder[j];
    }

    private int getItemOrder(aan item) {
        List<InvTweaksItemTreeItem> items = this.tree.getItems(this.getItemID(item), this.getItemDamage(item));
        return items != null && items.size() > 0 ? items.get(0).getOrder() : Integer.MAX_VALUE;
    }

    private void computeLineSortingRules(int rowSize, boolean horizontal) {
        int spaceWidth;
        int spaceHeight;
        this.rules = new Vector();
        Map<InvTweaksItemTreeItem, Integer> stats = this.computeContainerStats();
        ArrayList<InvTweaksItemTreeItem> itemOrder = new ArrayList<InvTweaksItemTreeItem>();
        int distinctItems = stats.size();
        int columnSize = this.getContainerColumnSize(rowSize);
        int availableSlots = this.size;
        int remainingStacks = 0;
        for (Integer stacks : stats.values()) {
            remainingStacks += stacks.intValue();
        }
        if (distinctItems == 0) {
            return;
        }
        ArrayList<InvTweaksItemTreeItem> unorderedItems = new ArrayList<InvTweaksItemTreeItem>(stats.keySet());
        boolean hasStacksToOrderFirst = true;
        block1: while (hasStacksToOrderFirst) {
            hasStacksToOrderFirst = false;
            for (InvTweaksItemTreeItem item : unorderedItems) {
                Integer value = stats.get(item);
                if (value <= (horizontal ? rowSize : columnSize) || itemOrder.contains(item)) continue;
                hasStacksToOrderFirst = true;
                itemOrder.add(item);
                unorderedItems.remove(item);
                continue block1;
            }
        }
        Collections.sort(unorderedItems, Collections.reverseOrder());
        itemOrder.addAll(unorderedItems);
        if (horizontal) {
            spaceHeight = 1;
            spaceWidth = rowSize / ((distinctItems + columnSize - 1) / columnSize);
        } else {
            spaceWidth = 1;
            spaceHeight = columnSize / ((distinctItems + rowSize - 1) / rowSize);
        }
        char row = 'a';
        char maxRow = (char)(row - 1 + columnSize);
        char column = '1';
        char maxColumn = (char)(column - 1 + rowSize);
        for (InvTweaksItemTreeItem item : itemOrder) {
            int thisSpaceWidth = spaceWidth;
            int thisSpaceHeight = spaceHeight;
            while (stats.get(item) > thisSpaceHeight * thisSpaceWidth) {
                if (horizontal) {
                    if (column + thisSpaceWidth < maxColumn) {
                        thisSpaceWidth = maxColumn - column + 1;
                        continue;
                    }
                    if (row + thisSpaceHeight >= maxRow) break;
                    ++thisSpaceHeight;
                    continue;
                }
                if (row + thisSpaceHeight < maxRow) {
                    thisSpaceHeight = maxRow - row + 1;
                    continue;
                }
                if (column + thisSpaceWidth >= maxColumn) break;
                ++thisSpaceWidth;
            }
            if (horizontal && column + thisSpaceWidth == maxColumn) {
                ++thisSpaceWidth;
            } else if (!horizontal && row + thisSpaceHeight == maxRow) {
                ++thisSpaceHeight;
            }
            String constraint = row + "" + column + "-" + (char)(row - '\u0001' + thisSpaceHeight) + (char)(column - '\u0001' + thisSpaceWidth);
            if (!horizontal) {
                constraint = constraint + 'v';
            }
            this.rules.add(new InvTweaksConfigSortingRule(this.tree, constraint, item.getName(), this.size, rowSize));
            if ((availableSlots -= thisSpaceHeight * thisSpaceWidth) < (remainingStacks -= stats.get(item).intValue())) break;
            if (horizontal) {
                if (column + thisSpaceWidth + spaceWidth <= maxColumn + '\u0001') {
                    column = (char)(column + thisSpaceWidth);
                } else {
                    column = '1';
                    row = (char)(row + thisSpaceHeight);
                }
            } else if (row + thisSpaceHeight + spaceHeight <= maxRow + '\u0001') {
                row = (char)(row + thisSpaceHeight);
            } else {
                row = 'a';
                column = (char)(column + thisSpaceWidth);
            }
            if (row <= maxRow && column <= maxColumn) continue;
            break;
        }
        String defaultRule = horizontal ? maxRow + "1-a" + maxColumn : "a" + maxColumn + "-" + maxRow + "1v";
        this.rules.add(new InvTweaksConfigSortingRule(this.tree, defaultRule, this.tree.getRootCategory().getName(), this.size, rowSize));
    }

    private Map<InvTweaksItemTreeItem, Integer> computeContainerStats() {
        HashMap<InvTweaksItemTreeItem, Integer> stats = new HashMap<InvTweaksItemTreeItem, Integer>();
        HashMap<Integer, InvTweaksItemTreeItem> itemSearch = new HashMap<Integer, InvTweaksItemTreeItem>();
        for (int i = 0; i < this.size; ++i) {
            aan stack = this.containerMgr.getItemStack(i);
            if (stack == null) continue;
            int itemSearchKey = this.getItemID(stack) * 100000 + (this.getMaxStackSize(stack) != 1 ? this.getItemDamage(stack) : 0);
            InvTweaksItemTreeItem item = (InvTweaksItemTreeItem)itemSearch.get(itemSearchKey);
            if (item == null) {
                item = this.tree.getItems(this.getItemID(stack), this.getItemDamage(stack)).get(0);
                itemSearch.put(itemSearchKey, item);
                stats.put(item, 1);
                continue;
            }
            stats.put(item, (Integer)stats.get(item) + 1);
        }
        return stats;
    }

    private int getContainerColumnSize(int rowSize) {
        return this.size / rowSize;
    }
}

