/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class InvTweaksLocalization {
    private static final Logger log = Logger.getLogger("InvTweaks");
    private static final String LANG_RESOURCES_LOCATION = "invtweaks/lang/";
    private static final String DEFAULT_LANGUAGE = "en_US";
    private static Properties defaultMappings = new Properties();
    private static Properties mappings = new Properties();
    private static String loadedLanguage = null;

    public static synchronized String get(String key) {
        String currentLanguage = InvTweaksObfuscation.getCurrentLanguage();
        if (!currentLanguage.equals(loadedLanguage)) {
            loadedLanguage = InvTweaksLocalization.load(currentLanguage);
        }
        return mappings.getProperty(key, defaultMappings.getProperty(key, key));
    }

    private static String load(String currentLanguage) {
        defaultMappings.clear();
        mappings.clear();
        try {
            InputStream langStream = InvTweaksLocalization.class.getResourceAsStream(LANG_RESOURCES_LOCATION + currentLanguage + ".properties");
            InputStream defaultLangStream = InvTweaksLocalization.class.getResourceAsStream("invtweaks/lang/en_US.properties");
            mappings.load(langStream == null ? defaultLangStream : langStream);
            defaultMappings.load(defaultLangStream);
            if (langStream != null) {
                langStream.close();
            }
            defaultLangStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentLanguage;
    }
}

