/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksItemTreeCategory {
    private static final Logger log = Logger.getLogger("InvTweaks");
    private final Map<Integer, List<InvTweaksItemTreeItem>> items = new HashMap<Integer, List<InvTweaksItemTreeItem>>();
    private final Vector<String> matchingItems = new Vector();
    private final Vector<InvTweaksItemTreeCategory> subCategories = new Vector();
    private String name;
    private int order = -1;

    public InvTweaksItemTreeCategory(String name) {
        this.name = name != null ? name.toLowerCase() : null;
    }

    public boolean contains(InvTweaksItemTreeItem item) {
        List<InvTweaksItemTreeItem> storedItems = this.items.get(item.getId());
        if (storedItems != null) {
            for (InvTweaksItemTreeItem storedItem : storedItems) {
                if (!storedItem.equals(item)) continue;
                return true;
            }
        }
        for (InvTweaksItemTreeCategory category : this.subCategories) {
            if (!category.contains(item)) continue;
            return true;
        }
        return false;
    }

    public void addCategory(InvTweaksItemTreeCategory category) {
        this.subCategories.add(category);
    }

    public void addItem(InvTweaksItemTreeItem item) {
        if (this.items.get(item.getId()) == null) {
            ArrayList<InvTweaksItemTreeItem> itemList = new ArrayList<InvTweaksItemTreeItem>();
            itemList.add(item);
            this.items.put(item.getId(), itemList);
        } else {
            this.items.get(item.getId()).add(item);
        }
        this.matchingItems.add(item.getName());
        if (this.order == -1 || this.order > item.getOrder()) {
            this.order = item.getOrder();
        }
    }

    public int getCategoryOrder() {
        if (this.order != -1) {
            return this.order;
        }
        for (InvTweaksItemTreeCategory category : this.subCategories) {
            int order = category.getCategoryOrder();
            if (order == -1) continue;
            return order;
        }
        return -1;
    }

    public int findCategoryOrder(String keyword) {
        if (keyword.equals(this.name)) {
            return this.getCategoryOrder();
        }
        for (InvTweaksItemTreeCategory category : this.subCategories) {
            int result = category.findCategoryOrder(keyword);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    public int findKeywordDepth(String keyword) {
        if (this.name.equals(keyword)) {
            return 0;
        }
        if (this.matchingItems.contains(keyword)) {
            return 1;
        }
        for (InvTweaksItemTreeCategory category : this.subCategories) {
            int result = category.findKeywordDepth(keyword);
            if (result == -1) continue;
            return result + 1;
        }
        return -1;
    }

    public Collection<InvTweaksItemTreeCategory> getSubCategories() {
        return this.subCategories;
    }

    public Collection<List<InvTweaksItemTreeItem>> getItems() {
        return this.items.values();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.subCategories.size() + " cats, " + this.items.size() + " items)";
    }
}

