/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.InvTweaksItemTreeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InvTweaksItemTreeLoader
extends DefaultHandler {
    private static final String ATTR_RANGE_MIN = "min";
    private static final String ATTR_RANGE_MAX = "max";
    private static final String ATTR_ID = "id";
    private static final String ATTR_DAMAGE = "damage";
    private static final String ATTR_TREE_VERSION = "treeVersion";
    private static InvTweaksItemTree tree;
    private static String treeVersion;
    private static int itemOrder;
    private static LinkedList<String> categoryStack;
    private static Boolean treeLoaded;
    private static List<InvTweaksItemTreeListener> onLoadListeners;

    private static void init() {
        treeLoaded = false;
        treeVersion = null;
        tree = new InvTweaksItemTree();
        itemOrder = 0;
        categoryStack = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InvTweaksItemTree load(String filePath) throws Exception {
        InvTweaksItemTreeLoader.init();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(new File(filePath), (DefaultHandler)new InvTweaksItemTreeLoader());
        List<InvTweaksItemTreeListener> list = onLoadListeners;
        synchronized (list) {
            treeLoaded = true;
            for (InvTweaksItemTreeListener onLoadListener : onLoadListeners) {
                onLoadListener.onTreeLoaded(tree);
            }
        }
        return tree;
    }

    public static synchronized boolean isValidVersion(String filePath) throws Exception {
        InvTweaksItemTreeLoader.init();
        File file = new File(filePath);
        if (file.exists()) {
            treeVersion = null;
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(file, (DefaultHandler)new InvTweaksItemTreeLoader());
            return "1.1.0".equals(treeVersion);
        }
        return false;
    }

    public static synchronized void addOnLoadListener(InvTweaksItemTreeListener listener) {
        onLoadListeners.add(listener);
        if (treeLoaded.booleanValue()) {
            listener.onTreeLoaded(tree);
        }
    }

    public static synchronized boolean removeOnLoadListener(InvTweaksItemTreeListener listener) {
        return onLoadListeners.remove(listener);
    }

    @Override
    public synchronized void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String rangeMinAttr = attributes.getValue(ATTR_RANGE_MIN);
        String newTreeVersion = attributes.getValue(ATTR_TREE_VERSION);
        if (attributes.getLength() == 0 || rangeMinAttr != null || treeVersion == null) {
            if (treeVersion == null) {
                treeVersion = newTreeVersion;
            }
            if (categoryStack.isEmpty()) {
                tree.setRootCategory(new InvTweaksItemTreeCategory(name));
            } else {
                tree.addCategory(categoryStack.getLast(), new InvTweaksItemTreeCategory(name));
            }
            if (rangeMinAttr != null) {
                int rangeMin = Integer.parseInt(rangeMinAttr);
                int rangeMax = Integer.parseInt(attributes.getValue(ATTR_RANGE_MAX));
                for (int i = rangeMin; i <= rangeMax; ++i) {
                    tree.addItem(name, new InvTweaksItemTreeItem((name + i).toLowerCase(), i, -1, itemOrder++));
                }
            }
            categoryStack.add(name);
        } else if (attributes.getValue(ATTR_ID) != null) {
            int id = Integer.parseInt(attributes.getValue(ATTR_ID));
            int damage = -1;
            if (attributes.getValue(ATTR_DAMAGE) != null) {
                damage = Integer.parseInt(attributes.getValue(ATTR_DAMAGE));
            }
            tree.addItem(categoryStack.getLast(), new InvTweaksItemTreeItem(name.toLowerCase(), id, damage, itemOrder++));
        }
    }

    @Override
    public synchronized void endElement(String uri, String localName, String name) throws SAXException {
        if (!categoryStack.isEmpty() && name.equals(categoryStack.getLast())) {
            categoryStack.removeLast();
        }
    }

    static {
        onLoadListeners = new ArrayList<InvTweaksItemTreeListener>();
    }
}

