/** 
 * Copyright (c) Krapht, 2012
 * 
 * "SneakyPipes" is distributed under the terms of the Minecraft Mod Public 
 * License 1.0, or MMPL. Please check the contents of the license located in
 * http://www.mod-buildcraft.com/MMPL-1.0.txt
 */

package net.minecraft.src.buildcraft.sneakypipes;

import java.util.LinkedList;

import net.minecraft.src.mod_SneakyPipes;
import net.minecraft.src.buildcraft.api.EntityPassiveItem;
import net.minecraft.src.buildcraft.api.Orientations;
import net.minecraft.src.buildcraft.api.Position;
import net.minecraft.src.buildcraft.transport.IPipeTransportItemsHook;
import net.minecraft.src.buildcraft.transport.Pipe;
import net.minecraft.src.buildcraft.transport.PipeLogic;
import net.minecraft.src.buildcraft.transport.PipeTransportItems;

public class GlassPipe extends Pipe implements IPipeTransportItemsHook{

	public GlassPipe(int itemID) {
		super(new PipeTransportItems(), new PipeLogic(), itemID);
	}
	
	@Override
	public int getMainBlockTexture() {
		return mod_SneakyPipes.glassPipeTexture;
	}

	@Override
	public LinkedList<Orientations> filterPossibleMovements(LinkedList<Orientations> possibleOrientations, Position pos, EntityPassiveItem item) {
		return possibleOrientations;
	}

	@Override
	public void entityEntered(EntityPassiveItem item, Orientations orientation) {}

	@Override
	public void readjustSpeed(EntityPassiveItem item) {}

}
