/** 
 * Copyright (c) Krapht, 2012
 * 
 * "SneakyPipes" is distributed under the terms of the Minecraft Mod Public 
 * License 1.0, or MMPL. Please check the contents of the license located in
 * http://www.mod-buildcraft.com/MMPL-1.0.txt
 */

package net.minecraft.src.buildcraft.sneakypipes;

import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_SneakyPipes;
import net.minecraft.src.buildcraft.transport.EntityData;
import net.minecraft.src.buildcraft.transport.IItemTravelingHook;
import net.minecraft.src.buildcraft.transport.PipeTransportItems;
import net.minecraft.src.buildcraft.transport.pipes.PipeItemsStone;

public class VoidPipe extends PipeItemsStone implements IItemTravelingHook{

	public VoidPipe(int itemID) {
		super(itemID);
		((PipeTransportItems) transport).travelHook = this;
	}
	
	@Override
	public int getMainBlockTexture() {
		return mod_SneakyPipes.voidPipeTexture;
	}

	@Override
	public void drop(PipeTransportItems pipe, EntityData data) {
		data.item.item.stackSize = 0;
	}

	@Override
	public void centerReached(PipeTransportItems pipe, EntityData data) {
		((PipeTransportItems) transport).scheduleRemoval(data.item);
	}

	@Override
	public void endReached(PipeTransportItems pipe, EntityData data, TileEntity tile) {}

}
