/** 
 * Copyright (c) Krapht, 2012
 * 
 * "SneakyPipes" is distributed under the terms of the Minecraft Mod Public 
 * License 1.0, or MMPL. Please check the contents of the license located in
 * http://www.mod-buildcraft.com/MMPL-1.0.txt
 */
package net.minecraft.src;

import java.io.File;

import net.minecraft.src.buildcraft.core.CoreProxy;
import net.minecraft.src.buildcraft.sneakypipes.GlassPipe;
import net.minecraft.src.buildcraft.sneakypipes.SandPipe;
import net.minecraft.src.buildcraft.sneakypipes.SneakyPipe;
import net.minecraft.src.buildcraft.sneakypipes.VoidPipe;
import net.minecraft.src.buildcraft.transport.BlockGenericPipe;
import net.minecraft.src.buildcraft.transport.Pipe;
import net.minecraft.src.forge.Configuration;
import net.minecraft.src.forge.MinecraftForgeClient;

/**
 *	ChangeLog:
 *
 *  0.1.1
 *  	* Ported to 1.2.5
 *
 *  0.1.0
 *  	* Ported to 1.2.3
 *  	* Added priorities fix so that it should always load after buildcraft
 *  	* Changed sand pipe recipe to sandstone, it's more solid that way
 *
 * 	0.0.3
 * 		* Fixed void pipe not using its configured ItemID
 *	
 *	0.0.2 
 *		* Fixed bug in sneakypipes that caused items to drop if the default slot couldn't accept an item even though the pipe was set to something else.
 *		* Increased the number of glass pipes crafted to 24
 */
public class mod_SneakyPipes extends BaseMod{

	public static Item sneakyPipe;
	public static Item sandPipe;
	public static Item glassPipe;
	public static Item voidPipe;
	
	public static int sneakyPipeTexture;
	public static int sandPipeTexture;
	public static int glassPipeTexture;
	public static int voidPipeTexture;
	
	@Override
	public String getVersion() {
		return "0.1.1 (Minecraft 1.2.5, Buildcraft 3.1.5, Forge 3.0.1.75)";
	}

	@Override
	public void load() {}
	
	@Override
	public void modsLoaded() {
		super.modsLoaded();
		BuildCraftCore.initialize();
		BuildCraftTransport.initialize();
		
		File configFile = new File(CoreProxy.getBuildCraftBase(), "config/SneakyPipes.cfg");
		Configuration configuration = new Configuration(configFile);
		configuration.load();
		
		boolean loadSneaky = Boolean.parseBoolean(configuration.getOrCreateBooleanProperty("enableSneaky", Configuration.CATEGORY_GENERAL, true).value);
		boolean loadSand = Boolean.parseBoolean(configuration.getOrCreateBooleanProperty("enableSand", Configuration.CATEGORY_GENERAL, true).value);
		boolean loadGlass = Boolean.parseBoolean(configuration.getOrCreateBooleanProperty("enableGlass", Configuration.CATEGORY_GENERAL, true).value);
		boolean loadVoid = Boolean.parseBoolean(configuration.getOrCreateBooleanProperty("enableVoid", Configuration.CATEGORY_GENERAL, true).value);
		
		int sneakyId = Integer.parseInt(configuration.getOrCreateIntProperty("sneakyId", Configuration.CATEGORY_ITEM, 7850).value);
		int sandId = Integer.parseInt(configuration.getOrCreateIntProperty("sandId", Configuration.CATEGORY_ITEM, 7851).value);
		int glassId = Integer.parseInt(configuration.getOrCreateIntProperty("glassId", Configuration.CATEGORY_ITEM, 7852).value);
		int voidId = Integer.parseInt(configuration.getOrCreateIntProperty("voidId", Configuration.CATEGORY_ITEM, 7853).value);
		
		configuration.save();
		
		CraftingManager craftingmanager = CraftingManager.getInstance();
		if (loadSneaky){
			sneakyPipeTexture = CoreProxy.addCustomTexture("/net/minecraft/src/buildcraft/sneakypipes/textures/sneakypipe.png");
			sneakyPipe = createPipe(sneakyId, SneakyPipe.class, "Sneaky Pipe");
			craftingmanager.addRecipe(new ItemStack(sneakyPipe, 2), new Object[]{"wrw", Character.valueOf('w'), BuildCraftTransport.pipeItemsWood, Character.valueOf('r'), Item.redstone});
		}
		
		if (loadSand){
			sandPipeTexture = CoreProxy.addCustomTexture("/net/minecraft/src/buildcraft/sneakypipes/textures/sandpipe.png");
			sandPipe = createPipe(sandId, SandPipe.class, "Sand Pipe");
			craftingmanager.addRecipe(new ItemStack(sandPipe, 8), new Object[]{"sgs", Character.valueOf('s'), Block.sandStone, Character.valueOf('g'), Block.glass});
		}
		
		if (loadGlass){
			glassPipeTexture = CoreProxy.addCustomTexture("/net/minecraft/src/buildcraft/sneakypipes/textures/glasspipe.png");
			glassPipe = createPipe(glassId, GlassPipe.class, "Glass Pipe");
			craftingmanager.addRecipe(new ItemStack(glassPipe, 24), new Object[]{"gdg", Character.valueOf('d'), Item.diamond, Character.valueOf('g'), Block.glass});
		}
		
		if (loadVoid){
			voidPipeTexture = CoreProxy.addCustomTexture("/net/minecraft/src/buildcraft/sneakypipes/textures/voidpipe.png");
			voidPipe = createPipe(voidId, VoidPipe.class, "Void Pipe");
			craftingmanager.addRecipe(new ItemStack(voidPipe, 1), new Object[]{"igr", Character.valueOf('i'), new ItemStack(Item.dyePowder,1,0), Character.valueOf('g'), Block.glass, Character.valueOf('r'), Item.redstone});
		}
	}
	
	@Override
	public String getPriorities() {
		return "after:mod_BuildCraftCore;after:mod_BuildCraftTransport";
	}


	private Item createPipe(int id, Class<? extends Pipe> clas, String description) {
		Item res = BlockGenericPipe.registerPipe(id, clas);
		res.setItemName(clas.getSimpleName());
		CoreProxy.addName(res, description);
		MinecraftForgeClient.registerItemRenderer(res.shiftedIndex, mod_BuildCraftTransport.instance);
		return res;
	}
}
